/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.jbpm.services.task.identity.LDAPUserInfoImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.task.api.model.Group;
import org.kie.internal.task.api.model.OrganizationalEntity;

@Ignore
public class LDAPUserInfoImplTest {
    @Test
    public void testGetEmailForUserEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new UserImpl("john"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"john@jbpm.org", (Object)email);
    }

    @Test
    public void testGetEmailForGroupEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.email.attr.id", "ou");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new GroupImpl("manager"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"managers@jbpm.org", (Object)email);
    }

    @Test
    public void testGetEmailForUserEntityAsDN() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.entity.id.dn", "true");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new UserImpl("uid=john,ou=People,dc=jbpm,dc=org"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"john@jbpm.org", (Object)email);
    }

    @Test
    public void testGetEmailForGroupEntityAsDN() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.entity.id.dn", "true");
        properties.setProperty("ldap.email.attr.id", "ou");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getEmailForEntity((OrganizationalEntity)new GroupImpl("cn=manager,ou=Roles,dc=jbpm,dc=org"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"managers@jbpm.org", (Object)email);
    }

    @Test
    public void testGetGroupMembers() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.member.attr.id", "member");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        Iterator members = ldapUserInfo.getMembersForGroup((Group)new GroupImpl("manager"));
        Assert.assertNotNull((Object)members);
        ArrayList<OrganizationalEntityImpl> orgMembers = new ArrayList<OrganizationalEntityImpl>();
        while (members.hasNext()) {
            OrganizationalEntityImpl organizationalEntity = (OrganizationalEntityImpl)members.next();
            orgMembers.add(organizationalEntity);
        }
        Assert.assertEquals((long)4L, (long)orgMembers.size());
    }

    @Test
    public void testGetNameForUserEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getDisplayName((OrganizationalEntity)new UserImpl("john"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"John Doe", (Object)email);
    }

    @Test
    public void testGetNameForGroupEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.name.attr.id", "description");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getDisplayName((OrganizationalEntity)new GroupImpl("manager"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"Manager group", (Object)email);
    }

    @Test
    public void testGetLangForUserEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getLanguageForEntity((OrganizationalEntity)new UserImpl("john"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"en-UK", (Object)email);
    }

    @Test
    public void testGetLangForGroupEntity() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jbpm,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jbpm,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        LDAPUserInfoImpl ldapUserInfo = new LDAPUserInfoImpl(properties);
        String email = ldapUserInfo.getLanguageForEntity((OrganizationalEntity)new GroupImpl("manager"));
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)"en-UK", (Object)email);
    }
}

