/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskResumedEvent;
import org.jbpm.services.task.events.BeforeTaskResumedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.kie.internal.task.api.model.User;

@Transactional
public class ResumeTaskCommand
extends TaskCommand {
    private long taskId;
    private String userId;

    public ResumeTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        boolean ownerAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskResumedEvent>(){}}).fire((Object)task);
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean bl = ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!(adminAllowed || potOwnerAllowed || ownerAllowed)) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if ((potOwnerAllowed || adminAllowed) && task.getTaskData().getPreviousStatus().equals((Object)Status.Ready)) {
            task.getTaskData().setStatus(task.getTaskData().getPreviousStatus());
        }
        if ((ownerAllowed || adminAllowed) && (task.getTaskData().getPreviousStatus().equals((Object)Status.Reserved) || task.getTaskData().getPreviousStatus().equals((Object)Status.InProgress))) {
            task.getTaskData().setStatus(task.getTaskData().getPreviousStatus());
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskResumedEvent>(){}}).fire((Object)task);
        return null;
    }

    private boolean isAllowed(UserImpl user, List<String> groupIds, List<OrganizationalEntityImpl> entities) {
        for (OrganizationalEntityImpl entity : entities) {
            if (entity instanceof UserImpl && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof GroupImpl) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }
}

