/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskSkippedEvent;
import org.jbpm.services.task.events.BeforeTaskSkippedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.Task;
import org.kie.internal.task.api.model.User;

@Transactional
public class SkipTaskCommand<Void>
extends TaskCommand {
    public SkipTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        boolean ownerAllowed;
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskSkippedEvent>(){}}).fire((Object)task);
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        boolean initiatorAllowed = task.getTaskData().getCreatedBy() != null && task.getTaskData().getCreatedBy().equals(user);
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean bl = ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        if (!(adminAllowed || potOwnerAllowed || initiatorAllowed || ownerAllowed)) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if ((adminAllowed || initiatorAllowed) && task.getTaskData().getStatus().equals((Object)Status.Created)) {
            task.getTaskData().setStatus(Status.Obsolete);
        }
        if ((adminAllowed || potOwnerAllowed) && task.getTaskData().getStatus().equals((Object)Status.Ready)) {
            task.getTaskData().setStatus(Status.Obsolete);
        }
        if ((adminAllowed || ownerAllowed) && (task.getTaskData().getStatus().equals((Object)Status.Reserved) || task.getTaskData().getStatus().equals((Object)Status.InProgress))) {
            task.getTaskData().setStatus(Status.Obsolete);
        }
        task.getTaskData().setSkipable(true);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskSkippedEvent>(){}}).fire((Object)task);
        return null;
    }
}

