/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.model.Status;
import org.kie.internal.task.api.model.TaskSummary;

@Named
@Transactional
@ApplicationScoped
public class TaskQueryServiceImpl
implements TaskQueryService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsBusinessAdministrator", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsExcludedOwner", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwner", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroup", (Map)this.pm.addParametersToMap(new Object[]{"groupId", groupId, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDateOptional(List<String> groupIds, String language, Date expirationDate) {
        List tasksByGroups = (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDateOptional", (Map)this.pm.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}));
        return this.collectTasksByPotentialOwners(tasksByGroups, language);
    }

    protected List<TaskSummary> collectTasksByPotentialOwners(List tasksByGroups, String language) {
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        for (Object o : tasksByGroups) {
            Object[] get = (Object[])o;
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.pm.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.pm.addParametersToMap(new Object[]{"taskIds", tasksIds, "language", language}));
            for (TaskSummary ts : tasks) {
                ts.setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public List<TaskSummary> getTasksAssignedByGroupsByExpirationDate(List<String> groupIds, String language, Date expirationDate) {
        List tasksByGroups = (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroupsByExpirationDate", (Map)this.pm.addParametersToMap(new Object[]{"groupIds", groupIds, "expirationDate", expirationDate}));
        return this.collectTasksByPotentialOwners(tasksByGroups, language);
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds, String language) {
        List tasksByGroups = (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByGroups", (Map)this.pm.addParametersToMap(new Object[]{"groupIds", groupIds}));
        Set<Long> tasksIds = Collections.synchronizedSet(new HashSet());
        Map potentialOwners = Collections.synchronizedMap(new HashMap());
        for (Object o : tasksByGroups) {
            Object[] get = (Object[])o;
            tasksIds.add((Long)get[0]);
            if (potentialOwners.get((Long)get[0]) == null) {
                potentialOwners.put((Long)get[0], new ArrayList());
            }
            ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
        }
        if (!tasksIds.isEmpty()) {
            List tasks = (List)this.pm.queryWithParametersInTransaction("TaskSummariesByIds", (Map)this.pm.addParametersToMap(new Object[]{"taskIds", tasksIds, "language", language}));
            for (TaskSummary ts : tasks) {
                ts.setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
            return tasks;
        }
        return new ArrayList<TaskSummary>();
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResults) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerWithGroups", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "language", language, "firstResult", firstResult, "maxResults", maxResults}));
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsRecipient", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsTaskInitiator", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language}));
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsTaskStakeholder", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language}));
    }

    public List<TaskSummary> getTasksOwned(String userId) {
        return (List)this.pm.queryWithParametersInTransaction("TasksOwned", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", "en-UK"}));
    }

    public List<TaskSummary> getTasksOwnedByExpirationDate(String userId, List<Status> status, Date expirationDate) {
        return (List)this.pm.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDate", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "status", status, "expirationDate", expirationDate, "language", "en-UK"}));
    }

    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, String language) {
        List taskOwned = (List)this.pm.queryWithParametersInTransaction("TasksOwnedWithParticularStatus", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "status", status, "language", language}));
        if (!taskOwned.isEmpty()) {
            HashSet<Long> tasksIds = new HashSet<Long>();
            for (TaskSummary ts : taskOwned) {
                tasksIds.add(ts.getId());
            }
            List tasksPotentialOwners = (List)this.pm.queryWithParametersInTransaction("TasksOwnedPotentialOwnersByTaskIds", (Map)this.pm.addParametersToMap(new Object[]{"taskIds", tasksIds}));
            HashMap potentialOwners = new HashMap();
            for (Object o : tasksPotentialOwners) {
                Object[] get = (Object[])o;
                tasksIds.add((Long)get[0]);
                if (potentialOwners.get((Long)get[0]) == null) {
                    potentialOwners.put((Long)get[0], new ArrayList());
                }
                ((List)potentialOwners.get((Long)get[0])).add((String)get[1]);
            }
            for (TaskSummary ts : taskOwned) {
                ts.setPotentialOwners((List)potentialOwners.get(ts.getId()));
            }
        } else {
            return new ArrayList<TaskSummary>(0);
        }
        return taskOwned;
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatus", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "language", language, "status", status}));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        return (List)this.pm.queryWithParametersInTransaction("TasksAssignedAsPotentialOwnerByStatusByGroup", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "groupIds", groupIds, "status", status, "language", language}));
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        return (List)this.pm.queryWithParametersInTransaction("SubTasksAssignedAsPotentialOwner", (Map)this.pm.addParametersToMap(new Object[]{"parentId", parentId, "userId", userId, "language", language}));
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return (List)this.pm.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.pm.addParametersToMap(new Object[]{"parentId", parentId, "language", "en-UK"}));
    }

    public int getPendingSubTasksByParent(long parentId) {
        return ((List)this.pm.queryWithParametersInTransaction("GetSubTasksByParentTaskId", (Map)this.pm.addParametersToMap(new Object[]{"parentId", parentId, "language", "en-UK"}))).size();
    }

    public TaskImpl getTaskInstanceById(long taskId) {
        TaskImpl taskInstance = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        return taskInstance;
    }

    public TaskImpl getTaskByWorkItemId(long workItemId) {
        List tasks = (List)this.pm.queryWithParametersInTransaction("TaskByWorkItemId", (Map)this.pm.addParametersToMap(new Object[]{"workItemId", workItemId, "maxResults", 1}));
        if (tasks.isEmpty()) {
            return null;
        }
        return (TaskImpl)tasks.get(0);
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> status, Date expirationDate) {
        return (List)this.pm.queryWithParametersInTransaction("TasksOwnedWithParticularStatusByExpirationDateOptional", (Map)this.pm.addParametersToMap(new Object[]{"userId", userId, "status", status, "expirationDate", expirationDate, "language", "en-UK"}));
    }

    public List<TaskSummary> getTasksByStatusByProcessId(long processInstanceId, List<Status> status, String language) {
        List tasks = (List)this.pm.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status, "language", language}));
        return tasks;
    }

    public List<TaskSummary> getTasksByStatusByProcessIdByTaskName(long processInstanceId, List<Status> status, String taskName, String language) {
        List tasks = (List)this.pm.queryWithParametersInTransaction("TasksByStatusByProcessIdByTaskName", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "status", status, "taskName", taskName, "language", language}));
        return tasks;
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        List tasks = (List)this.pm.queryWithParametersInTransaction("TasksByProcessInstanceId", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId}));
        return tasks;
    }
}

