/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskReleasedEvent;
import org.jbpm.services.task.events.BeforeTaskReleasedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
public class ReleaseTaskCommand
extends TaskCommand<Void> {
    public ReleaseTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskReleasedEvent>(){}}).fire((Object)task);
        boolean ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        boolean adminAllowed = this.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        if (!ownerAllowed && !adminAllowed) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if (task.getTaskData().getStatus().equals((Object)Status.Reserved) || task.getTaskData().getStatus().equals((Object)Status.InProgress)) {
            ((InternalTaskData)task.getTaskData()).setStatus(Status.Ready);
            ((InternalTaskData)task.getTaskData()).setActualOwner(null);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskReleasedEvent>(){}}).fire((Object)task);
        return null;
    }

    private boolean isAllowed(User user, List<String> groupIds, List<OrganizationalEntity> entities) {
        for (OrganizationalEntity entity : entities) {
            if (entity instanceof User && entity.equals(user)) {
                return true;
            }
            if (!(entity instanceof Group) || groupIds == null || !groupIds.contains(entity.getId())) continue;
            return true;
        }
        return false;
    }
}

