/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.AccessType;
import org.kie.internal.task.api.model.InternalAttachment;

@Entity
@Table(name="Attachment")
@SequenceGenerator(name="attachmentIdSeq", sequenceName="ATTACHMENT_ID_SEQ", allocationSize=1)
public class AttachmentImpl
implements InternalAttachment {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="attachmentIdSeq")
    private long id;
    private String name;
    private AccessType accessType = AccessType.Unknown;
    private String contentType;
    @ManyToOne
    private UserImpl attachedBy;
    private Date attachedAt;
    @Column(name="attachment_size")
    private int size;
    private long attachmentContentId;

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.name == null) {
            this.name = "";
        }
        out.writeUTF(this.name);
        out.writeUTF(this.accessType.toString());
        if (this.contentType == null) {
            this.contentType = "";
        }
        out.writeUTF(this.contentType);
        this.attachedBy.writeExternal(out);
        long attachedAtTime = 0L;
        if (this.attachedAt != null) {
            attachedAtTime = this.attachedAt.getTime();
        }
        out.writeLong(attachedAtTime);
        out.writeInt(this.size);
        out.writeLong(this.attachmentContentId);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.name = in.readUTF();
        this.accessType = AccessType.valueOf((String)in.readUTF());
        this.contentType = in.readUTF();
        this.attachedBy = new UserImpl();
        this.attachedBy.readExternal(in);
        this.attachedAt = new Date(in.readLong());
        this.size = in.readInt();
        this.attachmentContentId = in.readLong();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Date getAttachedAt() {
        return this.attachedAt;
    }

    public void setAttachedAt(Date attachedAt) {
        this.attachedAt = attachedAt;
    }

    public User getAttachedBy() {
        return this.attachedBy;
    }

    public void setAttachedBy(User attachedBy) {
        this.attachedBy = (UserImpl)attachedBy;
    }

    public int getSize() {
        return this.size;
    }

    public void setContent(Content content) {
        this.setSize(content.getContent().length);
        this.setAttachmentContentId(content.getId());
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getAttachmentContentId() {
        return this.attachmentContentId;
    }

    public void setAttachmentContentId(long contentId) {
        this.attachmentContentId = contentId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessType == null ? 0 : this.accessType.hashCode());
        result = 31 * result + (this.attachedAt == null ? 0 : this.attachedAt.hashCode());
        result = 31 * result + (this.attachedBy == null ? 0 : this.attachedBy.hashCode());
        result = 31 * result + this.size;
        result = 31 * result + (int)(this.attachmentContentId ^ this.attachmentContentId >>> 32);
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentImpl)) {
            return false;
        }
        AttachmentImpl other = (AttachmentImpl)obj;
        if (this.accessType == null ? other.accessType != null : !this.accessType.equals((Object)other.accessType)) {
            return false;
        }
        if (this.attachedAt == null ? other.attachedAt != null : this.attachedAt.getTime() != other.attachedAt.getTime()) {
            return false;
        }
        if (this.attachedBy == null ? other.attachedBy != null : !this.attachedBy.equals(other.attachedBy)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.attachmentContentId != other.attachmentContentId) {
            return false;
        }
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

