/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.wih;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.annotations.External;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.events.AfterTaskCompletedEvent;
import org.jbpm.task.events.AfterTaskFailedEvent;
import org.jbpm.task.events.AfterTaskSkippedEvent;
import org.jbpm.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.task.utils.ContentMarshallerHelper;

@ApplicationScoped
@External
@Alternative
public class ExternalTaskEventListener
implements TaskLifeCycleEventListener {
    @Inject
    private TaskServiceEntryPoint taskService;
    private KnowledgeRuntime session;
    private ClassLoader classLoader;

    public TaskServiceEntryPoint getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskServiceEntryPoint taskService) {
        this.taskService = taskService;
    }

    public KnowledgeRuntime getSession() {
        return this.session;
    }

    public void setSession(KnowledgeRuntime session) {
        this.session = session;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void processTaskState(Task task) {
        long workItemId = task.getTaskData().getWorkItemId();
        if (task.getTaskData().getStatus() == Status.Completed) {
            String userId = task.getTaskData().getActualOwner().getId();
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("ActorId", userId);
            long contentId = task.getTaskData().getOutputContentId();
            if (contentId != -1L) {
                Content content = this.taskService.getContentById(contentId);
                Object result = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)this.session.getEnvironment(), (ClassLoader)this.classLoader);
                results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this.session.getWorkItemManager().completeWorkItem(task.getTaskData().getWorkItemId(), results);
            } else {
                this.session.getWorkItemManager().completeWorkItem(workItemId, results);
            }
        } else {
            this.session.getWorkItemManager().abortWorkItem(workItemId);
        }
    }

    public void afterTaskActivatedEvent(Task ti) {
    }

    public void afterTaskClaimedEvent(Task ti) {
    }

    public void afterTaskSkippedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskSkippedEvent Task task) {
        this.processTaskState(task);
    }

    public void afterTaskStartedEvent(Task ti) {
    }

    public void afterTaskStoppedEvent(Task ti) {
    }

    public void afterTaskCompletedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskCompletedEvent Task task) {
        this.processTaskState(task);
    }

    public void afterTaskFailedEvent(@Observes(notifyObserver=Reception.IF_EXISTS) @AfterTaskFailedEvent Task task) {
        this.processTaskState(task);
    }

    public void afterTaskAddedEvent(Task ti) {
    }

    public void afterTaskExitedEvent(Task ti) {
    }
}

