/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.services.task.utils.OnErrorAction;
import org.jbpm.services.task.wih.util.HumanTaskHandlerHelper;
import org.jbpm.services.task.wih.util.PeopleAssignmentHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTWorkItemHandler.class);
    protected OnErrorAction action = OnErrorAction.LOG;

    public AbstractHTWorkItemHandler() {
    }

    public AbstractHTWorkItemHandler(OnErrorAction action) {
        this.action = action;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    protected Task createTaskBasedOnWorkItemParams(KieSession session, WorkItem workItem) {
        String createdBy;
        String comment;
        String formName;
        TaskImpl task = new TaskImpl();
        String taskName = (String)workItem.getParameter("NodeName");
        if (taskName != null) {
            ArrayList<I18NTextImpl> names = new ArrayList<I18NTextImpl>();
            names.add(new I18NTextImpl("en-UK", taskName));
            task.setNames(names);
        }
        if ((formName = (String)workItem.getParameter("TaskName")) != null) {
            task.setFormName(formName);
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        ArrayList<I18NTextImpl> descriptions = new ArrayList<I18NTextImpl>();
        descriptions.add(new I18NTextImpl("en-UK", comment));
        task.setDescriptions(descriptions);
        ArrayList<I18NTextImpl> subjects = new ArrayList<I18NTextImpl>();
        subjects.add(new I18NTextImpl("en-UK", comment));
        task.setSubjects(subjects);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskDataImpl taskData = new TaskDataImpl();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (session != null && session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
            taskData.setProcessId(session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
            String deploymentId = ((WorkItemImpl)workItem).getDeploymentId();
            taskData.setDeploymentId(deploymentId);
        }
        if (session != null && session instanceof KieSession) {
            taskData.setProcessSessionId(session.getId());
        }
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId.longValue());
        }
        if ((createdBy = (String)workItem.getParameter("CreatedBy")) != null && createdBy.trim().length() > 0) {
            taskData.setCreatedBy((User)new UserImpl(createdBy));
        }
        String dueDateString = (String)workItem.getParameter("DueDate");
        Date date = null;
        if (dueDateString != null && !dueDateString.isEmpty()) {
            if (DateTimeUtils.isPeriod((String)dueDateString)) {
                Long longDateValue = DateTimeUtils.parseDateAsDuration((String)dueDateString.substring(1));
                date = new Date(System.currentTimeMillis() + longDateValue);
            } else {
                date = new Date(DateTimeUtils.parseDateTime((String)dueDateString));
            }
        }
        if (date != null) {
            taskData.setExpirationTime(date);
        }
        PeopleAssignmentHelper peopleAssignmentHelper = new PeopleAssignmentHelper();
        peopleAssignmentHelper.handlePeopleAssignments(workItem, (InternalTask)task, (InternalTaskData)taskData);
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        taskData.initialize();
        task.setTaskData((TaskData)taskData);
        task.setDeadlines(HumanTaskHandlerHelper.setDeadlines(workItem, businessAdministrators, session.getEnvironment()));
        return task;
    }

    protected ContentData createTaskContentBasedOnWorkItemParams(KieSession session, WorkItem workItem) {
        ContentDataImpl content = null;
        HashMap contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            contentObject = new HashMap(workItem.getParameters());
        }
        if (contentObject != null) {
            Environment env = null;
            if (session != null) {
                session.getEnvironment();
            }
            content = ContentMarshallerHelper.marshal(contentObject, env);
        }
        return content;
    }

    protected boolean isAutoClaim(WorkItem workItem, Task task) {
        String swimlaneUser = (String)workItem.getParameter("SwimlaneActorId");
        return swimlaneUser != null && !"".equals(swimlaneUser) && task.getTaskData().getStatus() == Status.Ready;
    }

    public abstract void executeWorkItem(WorkItem var1, WorkItemManager var2);

    public abstract void abortWorkItem(WorkItem var1, WorkItemManager var2);
}

