/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.wih;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.task.ContentData;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.jbpm.task.utils.OnErrorAction;
import org.kie.runtime.Environment;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemHandler;
import org.kie.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTWorkItemHandler.class);
    protected KnowledgeRuntime session;
    protected OnErrorAction action;

    public AbstractHTWorkItemHandler() {
    }

    public AbstractHTWorkItemHandler(KnowledgeRuntime session) {
        this.session = session;
        this.action = OnErrorAction.LOG;
    }

    public AbstractHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action) {
        this.session = session;
        this.action = action;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    public KnowledgeRuntime getSession() {
        return this.session;
    }

    public void setSession(KnowledgeRuntime session) {
        this.session = session;
    }

    protected Task createTaskBasedOnWorkItemParams(WorkItem workItem) {
        String groupId;
        String comment;
        Task task = new Task();
        String taskName = (String)workItem.getParameter("TaskName");
        if (taskName != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            names.add(new I18NText("en-UK", taskName));
            task.setNames(names);
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        descriptions.add(new I18NText("en-UK", comment));
        task.setDescriptions(descriptions);
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        subjects.add(new I18NText("en-UK", comment));
        task.setSubjects(subjects);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        TaskData taskData = new TaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (this.session != null && this.session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
            taskData.setProcessId(this.session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
        }
        if (this.session != null && this.session instanceof StatefulKnowledgeSession) {
            taskData.setProcessSessionId(((StatefulKnowledgeSession)this.session).getId());
        }
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId.longValue());
        }
        PeopleAssignments assignments = new PeopleAssignments();
        ArrayList<Object> potentialOwners = new ArrayList<Object>();
        String actorId = (String)workItem.getParameter("ActorId");
        if (actorId != null && actorId.trim().length() > 0) {
            String[] actorIds;
            for (String id : actorIds = actorId.split(",")) {
                potentialOwners.add(new User(id.trim()));
            }
            if (potentialOwners.size() > 0) {
                taskData.setCreatedBy((User)potentialOwners.get(0));
            }
        }
        if ((groupId = (String)workItem.getParameter("GroupId")) != null && groupId.trim().length() > 0) {
            String[] groupIds;
            for (String id : groupIds = groupId.split(",")) {
                potentialOwners.add(new Group(id.trim()));
            }
        }
        assignments.setPotentialOwners(potentialOwners);
        ArrayList<User> businessAdministrators = new ArrayList<User>();
        businessAdministrators.add(new User("Administrator"));
        assignments.setBusinessAdministrators(businessAdministrators);
        task.setPeopleAssignments(assignments);
        task.setTaskData(taskData);
        return task;
    }

    protected ContentData createTaskContentBasedOnWorkItemParams(WorkItem workItem) {
        ContentData content = null;
        HashMap contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            contentObject = new HashMap(workItem.getParameters());
        }
        if (contentObject != null) {
            Environment env = null;
            if (this.session != null) {
                this.session.getEnvironment();
            }
            content = ContentMarshallerHelper.marshal(contentObject, env);
        }
        return content;
    }

    public abstract void executeWorkItem(WorkItem var1, WorkItemManager var2);

    public abstract void abortWorkItem(WorkItem var1, WorkItemManager var2);
}

