/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.wih;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.task.ContentData;
import org.jbpm.task.Task;
import org.jbpm.task.annotations.External;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.exception.PermissionDeniedException;
import org.jbpm.task.impl.factories.TaskFactory;
import org.jbpm.task.utils.OnErrorAction;
import org.jbpm.task.wih.AbstractHTWorkItemHandler;
import org.jbpm.task.wih.ExternalTaskEventListener;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CDIHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(CDIHTWorkItemHandler.class);
    private ClassLoader classLoader;
    @Inject
    private TaskServiceEntryPoint taskService;
    @Inject
    @External
    private ExternalTaskEventListener listener;

    public void init() {
        this.listener.setClassLoader(this.classLoader);
        this.listener.setSession(this.session);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TaskServiceEntryPoint getTaskService() {
        return this.taskService;
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block5: {
            Task task = this.createTaskBasedOnWorkItemParams(workItem);
            TaskFactory.initializeTask((Task)task);
            ContentData content = this.createTaskContentBasedOnWorkItemParams(workItem);
            try {
                this.taskService.addTask(task, content);
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    manager.abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block5;
                StringBuilder logMsg = new StringBuilder();
                logMsg.append(new Date()).append(": Error when creating task on task server for work item id ").append(workItem.getId());
                logMsg.append(". Error reported by task server: ").append(e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Task task = this.taskService.getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                this.taskService.exit(task.getId().longValue(), "Administrator");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }
}

