/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.wih;

import java.util.Date;
import org.jbpm.task.ContentData;
import org.jbpm.task.Task;
import org.jbpm.task.api.TaskServiceEntryPoint;
import org.jbpm.task.exception.PermissionDeniedException;
import org.jbpm.task.impl.factories.TaskFactory;
import org.jbpm.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.task.utils.OnErrorAction;
import org.jbpm.task.wih.AbstractHTWorkItemHandler;
import org.jbpm.task.wih.ExternalTaskEventListener;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.process.WorkItem;
import org.kie.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(GenericHTWorkItemHandler.class);
    private TaskServiceEntryPoint client;
    private String ipAddress;
    private int port;
    private boolean local = false;
    private boolean connected = false;
    private ClassLoader classLoader;
    private TaskLifeCycleEventListener taskLifeCycleEventListener;

    public GenericHTWorkItemHandler(KnowledgeRuntime session, OnErrorAction action) {
        super(session, action);
    }

    public GenericHTWorkItemHandler(TaskServiceEntryPoint client, KnowledgeRuntime session, OnErrorAction action) {
        super(session, action);
        this.client = client;
    }

    public GenericHTWorkItemHandler(TaskServiceEntryPoint client, KnowledgeRuntime session, OnErrorAction action, ClassLoader classLoader) {
        super(session, action);
        this.client = client;
        this.classLoader = classLoader;
    }

    public GenericHTWorkItemHandler(TaskServiceEntryPoint client, KnowledgeRuntime session) {
        super(session);
        this.client = client;
    }

    public GenericHTWorkItemHandler(KnowledgeRuntime session) {
        super(session);
    }

    public TaskServiceEntryPoint getClient() {
        return this.client;
    }

    public void setClient(TaskServiceEntryPoint client) {
        this.client = client;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getPort() {
        return this.port;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void init() {
        this.taskLifeCycleEventListener = this.client.getTaskLifeCycleEventListener();
        ((ExternalTaskEventListener)this.taskLifeCycleEventListener).setSession(this.session);
        ((ExternalTaskEventListener)this.taskLifeCycleEventListener).setTaskService(this.client);
    }

    public void dispose() throws Exception {
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block5: {
            Task task = this.createTaskBasedOnWorkItemParams(workItem);
            TaskFactory.initializeTask((Task)task);
            ContentData content = this.createTaskContentBasedOnWorkItemParams(workItem);
            try {
                this.client.addTask(task, content);
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    manager.abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block5;
                StringBuffer logMsg = new StringBuffer();
                logMsg.append(new Date() + ": Error when creating task on task server for work item id " + workItem.getId());
                logMsg.append(". Error reported by task server: " + e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        Task task = this.client.getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                this.client.exit(task.getId().longValue(), "Administrator");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }
}

