/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.internals;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import javax.transaction.UserTransaction;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceNio2WrapperImpl;

public class TaskEnvironmentProducer {
    private static final String ORIGIN_URL = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground.git";
    private IOService ioService = new IOServiceNio2WrapperImpl();
    private EntityManagerFactory emf;

    @Produces
    public Logger createLogger(InjectionPoint injectionPoint) {
        return Logger.getLogger(injectionPoint.getMember().getDeclaringClass().getName());
    }

    @PersistenceUnit(unitName="org.jbpm.services.task")
    @ApplicationScoped
    @Produces
    public EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        }
        return this.emf;
    }

    @Produces
    @ApplicationScoped
    public EntityManager getEntityManager() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        EntityManager emProxy = (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new EmInvocationHandler(em));
        return emProxy;
    }

    @ApplicationScoped
    public void commitAndClose(@Disposes EntityManager em) {
        try {
            em.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService prepareFileSystem() {
        try {
            String userName = "guvnorngtestuser1";
            String password = "test1234";
            URI fsURI = URI.create("git://jbpm-playground");
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("username", "guvnorngtestuser1");
            env.put("password", "test1234");
            env.put("origin", ORIGIN_URL);
            this.ioService.newFileSystem(fsURI, env, (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
        }
        catch (Exception e) {
            System.out.println(">>>>>>>>>>>>>>>>>>> E " + e.getMessage());
        }
        return this.ioService;
    }

    private class EmInvocationHandler
    implements InvocationHandler {
        private EntityManager delegate;

        EmInvocationHandler(EntityManager em) {
            this.delegate = em;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.joinTransactionIfNeeded();
            return method.invoke((Object)this.delegate, args);
        }

        private void joinTransactionIfNeeded() {
            try {
                UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                if (ut.getStatus() == 0) {
                    this.delegate.joinTransaction();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

