/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.wih.util.PeopleAssignmentHelper;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;

public class PeopleAssignmentHelperTest
extends TestCase {
    private PeopleAssignmentHelper peopleAssignmentHelper = new PeopleAssignmentHelper();

    protected void setup() {
        this.peopleAssignmentHelper = new PeopleAssignmentHelper();
    }

    @Test
    public void testProcessPeopleAssignments() {
        ArrayList organizationalEntities = new ArrayList();
        String ids = "espiegelberg,   drbug   ";
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, true);
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 2 ? 1 : 0) != 0);
        organizationalEntities.contains("drbug");
        organizationalEntities.contains("espiegelberg");
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntities.get(0) instanceof UserImpl));
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntities.get(1) instanceof UserImpl));
        ids = null;
        organizationalEntities = new ArrayList();
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, true);
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        ids = "     ";
        organizationalEntities = new ArrayList();
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, true);
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        ids = "Software Developer";
        organizationalEntities = new ArrayList();
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, false);
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 1 ? 1 : 0) != 0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntities.get(0) instanceof GroupImpl));
        ids = "Software Developer,Project Manager";
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, false);
        PeopleAssignmentHelperTest.assertTrue((organizationalEntities.size() == 2 ? 1 : 0) != 0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntities.get(0) instanceof GroupImpl));
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntities.get(1) instanceof GroupImpl));
    }

    @Test
    public void testAssignActors() {
        String actorId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        PeopleAssignmentHelperTest.assertEquals((String)actorId, (String)organizationalEntity1.getId());
        PeopleAssignmentHelperTest.assertEquals((String)actorId, (String)taskData.getCreatedBy().getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)(actorId + ", drbug  "));
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)peopleAssignments.getPotentialOwners().size());
        organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        PeopleAssignmentHelperTest.assertEquals((String)actorId, (String)organizationalEntity1.getId());
        PeopleAssignmentHelperTest.assertEquals((String)actorId, (String)taskData.getCreatedBy().getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        PeopleAssignmentHelperTest.assertEquals((String)"drbug", (String)organizationalEntity2.getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)"");
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignments.getPotentialOwners().size());
    }

    @Test
    public void testAssignBusinessAdministrators() {
        String businessAdministratorId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("BusinessAdministratorId", (Object)businessAdministratorId);
        this.peopleAssignmentHelper.assignBusinessAdministrators((WorkItem)workItem, (PeopleAssignments)peopleAssignments);
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)peopleAssignments.getBusinessAdministrators().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getBusinessAdministrators().get(0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        PeopleAssignmentHelperTest.assertEquals((String)"Administrator", (String)organizationalEntity1.getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getBusinessAdministrators().get(1);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity2 instanceof UserImpl));
        PeopleAssignmentHelperTest.assertEquals((String)businessAdministratorId, (String)organizationalEntity2.getId());
    }

    @Test
    public void testAssignTaskstakeholders() {
        String taskStakeholderId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("TaskStakeholderId", (Object)taskStakeholderId);
        this.peopleAssignmentHelper.assignTaskStakeholders((WorkItem)workItem, peopleAssignments);
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)peopleAssignments.getTaskStakeholders().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getTaskStakeholders().get(0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        PeopleAssignmentHelperTest.assertEquals((String)taskStakeholderId, (String)organizationalEntity1.getId());
    }

    @Test
    public void testAssignGroups() {
        String groupId = "Software Developers, Project Managers";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("GroupId", (Object)groupId);
        this.peopleAssignmentHelper.assignGroups((WorkItem)workItem, (PeopleAssignments)peopleAssignments);
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity1 instanceof GroupImpl));
        PeopleAssignmentHelperTest.assertEquals((String)"Software Developers", (String)organizationalEntity1.getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity2 instanceof GroupImpl));
        PeopleAssignmentHelperTest.assertEquals((String)"Project Managers", (String)organizationalEntity2.getId());
    }

    @Test
    public void testgetNullSafePeopleAssignments() {
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        PeopleAssignmentHelperTest.assertNotNull((Object)peopleAssignment);
        peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        PeopleAssignmentHelperTest.assertNotNull((Object)peopleAssignment);
        task.setPeopleAssignments(null);
        peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        PeopleAssignmentHelperTest.assertNotNull((Object)peopleAssignment);
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getPotentialOwners().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getBusinessAdministrators().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getExcludedOwners().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getRecipients().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getTaskStakeholders().size());
    }

    @Test
    public void testHandlePeopleAssignments() {
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        PeopleAssignmentHelperTest.assertNotNull((Object)peopleAssignment);
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getPotentialOwners().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getBusinessAdministrators().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getTaskStakeholders().size());
        String actorId = "espiegelberg";
        String taskStakeholderId = "drmary";
        String businessAdministratorId = "drbug";
        String excludedOwnerId = "john";
        String recipientId = "mary";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        workItem.setParameter("TaskStakeholderId", (Object)taskStakeholderId);
        workItem.setParameter("BusinessAdministratorId", (Object)businessAdministratorId);
        workItem.setParameter("ExcludedOwnerId", (Object)excludedOwnerId);
        workItem.setParameter("RecipientId", (Object)recipientId);
        this.peopleAssignmentHelper.handlePeopleAssignments((WorkItem)workItem, (InternalTask)task, (InternalTaskData)taskData);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)potentialOwners.size());
        PeopleAssignmentHelperTest.assertEquals((String)actorId, (String)((OrganizationalEntity)potentialOwners.get(0)).getId());
        List businessAdministrators = task.getPeopleAssignments().getBusinessAdministrators();
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)businessAdministrators.size());
        PeopleAssignmentHelperTest.assertEquals((String)"Administrator", (String)((OrganizationalEntity)businessAdministrators.get(0)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)businessAdministratorId, (String)((OrganizationalEntity)businessAdministrators.get(1)).getId());
        List taskStakehoders = ((InternalPeopleAssignments)task.getPeopleAssignments()).getTaskStakeholders();
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)taskStakehoders.size());
        PeopleAssignmentHelperTest.assertEquals((String)taskStakeholderId, (String)((OrganizationalEntity)taskStakehoders.get(0)).getId());
        List excludedOwners = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)excludedOwners.size());
        PeopleAssignmentHelperTest.assertEquals((String)excludedOwnerId, (String)((OrganizationalEntity)excludedOwners.get(0)).getId());
        List recipients = ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients();
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)recipients.size());
        PeopleAssignmentHelperTest.assertEquals((String)recipientId, (String)((OrganizationalEntity)recipients.get(0)).getId());
    }

    @Test
    public void testHandleMultiPeopleAssignments() {
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        PeopleAssignmentHelperTest.assertNotNull((Object)peopleAssignment);
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getPotentialOwners().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getBusinessAdministrators().size());
        PeopleAssignmentHelperTest.assertEquals((int)0, (int)peopleAssignment.getTaskStakeholders().size());
        String actorId = "espiegelberg,john";
        String taskStakeholderId = "drmary,krisv";
        String businessAdministratorId = "drbug,peter";
        String excludedOwnerId = "john,poul";
        String recipientId = "mary,steve";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        workItem.setParameter("TaskStakeholderId", (Object)taskStakeholderId);
        workItem.setParameter("BusinessAdministratorId", (Object)businessAdministratorId);
        workItem.setParameter("ExcludedOwnerId", (Object)excludedOwnerId);
        workItem.setParameter("RecipientId", (Object)recipientId);
        this.peopleAssignmentHelper.handlePeopleAssignments((WorkItem)workItem, (InternalTask)task, (InternalTaskData)taskData);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)potentialOwners.size());
        PeopleAssignmentHelperTest.assertEquals((String)"espiegelberg", (String)((OrganizationalEntity)potentialOwners.get(0)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)"john", (String)((OrganizationalEntity)potentialOwners.get(1)).getId());
        List businessAdministrators = task.getPeopleAssignments().getBusinessAdministrators();
        PeopleAssignmentHelperTest.assertEquals((int)3, (int)businessAdministrators.size());
        PeopleAssignmentHelperTest.assertEquals((String)"Administrator", (String)((OrganizationalEntity)businessAdministrators.get(0)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)"drbug", (String)((OrganizationalEntity)businessAdministrators.get(1)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)"peter", (String)((OrganizationalEntity)businessAdministrators.get(2)).getId());
        List taskStakehoders = ((InternalPeopleAssignments)task.getPeopleAssignments()).getTaskStakeholders();
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)taskStakehoders.size());
        PeopleAssignmentHelperTest.assertEquals((String)"drmary", (String)((OrganizationalEntity)taskStakehoders.get(0)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)"krisv", (String)((OrganizationalEntity)taskStakehoders.get(1)).getId());
        List excludedOwners = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)excludedOwners.size());
        PeopleAssignmentHelperTest.assertEquals((String)"john", (String)((OrganizationalEntity)excludedOwners.get(0)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)"poul", (String)((OrganizationalEntity)excludedOwners.get(1)).getId());
        List recipients = ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients();
        PeopleAssignmentHelperTest.assertEquals((int)2, (int)recipients.size());
        PeopleAssignmentHelperTest.assertEquals((String)"mary", (String)((OrganizationalEntity)recipients.get(0)).getId());
        PeopleAssignmentHelperTest.assertEquals((String)"steve", (String)((OrganizationalEntity)recipients.get(1)).getId());
    }

    @Test
    public void testAssignExcludedOwners() {
        String excludedOwnerId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ExcludedOwnerId", (Object)excludedOwnerId);
        this.peopleAssignmentHelper.assignExcludedOwners((WorkItem)workItem, peopleAssignments);
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)peopleAssignments.getExcludedOwners().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getExcludedOwners().get(0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        PeopleAssignmentHelperTest.assertEquals((String)excludedOwnerId, (String)organizationalEntity1.getId());
    }

    @Test
    public void testAssignRecipients() {
        String recipientId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("RecipientId", (Object)recipientId);
        this.peopleAssignmentHelper.assignRecipients((WorkItem)workItem, peopleAssignments);
        PeopleAssignmentHelperTest.assertEquals((int)1, (int)peopleAssignments.getRecipients().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getRecipients().get(0);
        PeopleAssignmentHelperTest.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        PeopleAssignmentHelperTest.assertEquals((String)recipientId, (String)organizationalEntity1.getId());
    }
}

