/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.wih.util.PeopleAssignmentHelper;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;

public class PeopleAssignmentHelperTest
extends AbstractBaseTest {
    private PeopleAssignmentHelper peopleAssignmentHelper;

    @Before
    public void setup() {
        this.peopleAssignmentHelper = new PeopleAssignmentHelper();
    }

    @Test
    public void testProcessPeopleAssignments() {
        ArrayList organizationalEntities = new ArrayList();
        String ids = "espiegelberg,   drbug   ";
        Assert.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, true);
        Assert.assertTrue((organizationalEntities.size() == 2 ? 1 : 0) != 0);
        organizationalEntities.contains("drbug");
        organizationalEntities.contains("espiegelberg");
        Assert.assertTrue((boolean)(organizationalEntities.get(0) instanceof UserImpl));
        Assert.assertTrue((boolean)(organizationalEntities.get(1) instanceof UserImpl));
        ids = null;
        organizationalEntities = new ArrayList();
        Assert.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, true);
        Assert.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        ids = "     ";
        organizationalEntities = new ArrayList();
        Assert.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, true);
        Assert.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        ids = "Software Developer";
        organizationalEntities = new ArrayList();
        Assert.assertTrue((organizationalEntities.size() == 0 ? 1 : 0) != 0);
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, false);
        Assert.assertTrue((organizationalEntities.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(organizationalEntities.get(0) instanceof GroupImpl));
        ids = "Software Developer,Project Manager";
        this.peopleAssignmentHelper.processPeopleAssignments(ids, organizationalEntities, false);
        Assert.assertTrue((organizationalEntities.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(organizationalEntities.get(0) instanceof GroupImpl));
        Assert.assertTrue((boolean)(organizationalEntities.get(1) instanceof GroupImpl));
    }

    @Test
    public void testAssignActors() {
        String actorId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)actorId, (Object)organizationalEntity1.getId());
        Assert.assertEquals((Object)actorId, (Object)taskData.getCreatedBy().getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)(actorId + ", drbug  "));
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        Assert.assertEquals((long)2L, (long)peopleAssignments.getPotentialOwners().size());
        organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertEquals((Object)actorId, (Object)organizationalEntity1.getId());
        Assert.assertEquals((Object)actorId, (Object)taskData.getCreatedBy().getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        Assert.assertEquals((Object)"drbug", (Object)organizationalEntity2.getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)"");
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        Assert.assertEquals((long)0L, (long)peopleAssignments.getPotentialOwners().size());
    }

    @Test
    public void testAssignActorsWithCustomSeparatorViaSysProp() {
        System.setProperty("org.jbpm.ht.user.separator", ";");
        this.peopleAssignmentHelper = new PeopleAssignmentHelper();
        String actorId = "user1;user2";
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)"user1", (Object)organizationalEntity1.getId());
        Assert.assertEquals((Object)"user1", (Object)taskData.getCreatedBy().getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        Assert.assertTrue((boolean)(organizationalEntity2 instanceof UserImpl));
        Assert.assertEquals((Object)"user2", (Object)organizationalEntity2.getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)(actorId + "; drbug  "));
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        Assert.assertEquals((long)3L, (long)peopleAssignments.getPotentialOwners().size());
        organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertEquals((Object)"user1", (Object)organizationalEntity1.getId());
        Assert.assertEquals((Object)"user1", (Object)taskData.getCreatedBy().getId());
        organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        Assert.assertTrue((boolean)(organizationalEntity2 instanceof UserImpl));
        Assert.assertEquals((Object)"user2", (Object)organizationalEntity2.getId());
        OrganizationalEntity organizationalEntity3 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(2);
        Assert.assertEquals((Object)"drbug", (Object)organizationalEntity3.getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)"");
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        Assert.assertEquals((long)0L, (long)peopleAssignments.getPotentialOwners().size());
        System.clearProperty("org.jbpm.ht.user.separator");
    }

    @Test
    public void testAssignActorsWithCustomSeparator() {
        this.peopleAssignmentHelper = new PeopleAssignmentHelper(":");
        String actorId = "user1:user2";
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)"user1", (Object)organizationalEntity1.getId());
        Assert.assertEquals((Object)"user1", (Object)taskData.getCreatedBy().getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        Assert.assertTrue((boolean)(organizationalEntity2 instanceof UserImpl));
        Assert.assertEquals((Object)"user2", (Object)organizationalEntity2.getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)(actorId + ": drbug  "));
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        Assert.assertEquals((long)3L, (long)peopleAssignments.getPotentialOwners().size());
        organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertEquals((Object)"user1", (Object)organizationalEntity1.getId());
        Assert.assertEquals((Object)"user1", (Object)taskData.getCreatedBy().getId());
        organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        Assert.assertTrue((boolean)(organizationalEntity2 instanceof UserImpl));
        Assert.assertEquals((Object)"user2", (Object)organizationalEntity2.getId());
        OrganizationalEntity organizationalEntity3 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(2);
        Assert.assertEquals((Object)"drbug", (Object)organizationalEntity3.getId());
        workItem = new WorkItemImpl();
        peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        workItem.setParameter("ActorId", (Object)"");
        this.peopleAssignmentHelper.assignActors((WorkItem)workItem, (PeopleAssignments)peopleAssignments, (InternalTaskData)taskData);
        Assert.assertEquals((long)0L, (long)peopleAssignments.getPotentialOwners().size());
    }

    @Test
    public void testAssignBusinessAdministrators() {
        String businessAdministratorId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("BusinessAdministratorId", (Object)businessAdministratorId);
        this.peopleAssignmentHelper.assignBusinessAdministrators((WorkItem)workItem, (PeopleAssignments)peopleAssignments);
        Assert.assertEquals((long)3L, (long)peopleAssignments.getBusinessAdministrators().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getBusinessAdministrators().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)"Administrator", (Object)organizationalEntity1.getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getBusinessAdministrators().get(1);
        Assert.assertTrue((boolean)(organizationalEntity2 instanceof GroupImpl));
        Assert.assertEquals((Object)"Administrators", (Object)organizationalEntity2.getId());
        OrganizationalEntity organizationalEntity3 = (OrganizationalEntity)peopleAssignments.getBusinessAdministrators().get(2);
        Assert.assertTrue((boolean)(organizationalEntity3 instanceof UserImpl));
        Assert.assertEquals((Object)businessAdministratorId, (Object)organizationalEntity3.getId());
    }

    @Test
    public void testAssignTaskstakeholders() {
        String taskStakeholderId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("TaskStakeholderId", (Object)taskStakeholderId);
        this.peopleAssignmentHelper.assignTaskStakeholders((WorkItem)workItem, peopleAssignments);
        Assert.assertEquals((long)1L, (long)peopleAssignments.getTaskStakeholders().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getTaskStakeholders().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)taskStakeholderId, (Object)organizationalEntity1.getId());
    }

    @Test
    public void testAssignGroups() {
        String groupId = "Software Developers, Project Managers";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("GroupId", (Object)groupId);
        this.peopleAssignmentHelper.assignGroups((WorkItem)workItem, (PeopleAssignments)peopleAssignments);
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof GroupImpl));
        Assert.assertEquals((Object)"Software Developers", (Object)organizationalEntity1.getId());
        OrganizationalEntity organizationalEntity2 = (OrganizationalEntity)peopleAssignments.getPotentialOwners().get(1);
        Assert.assertTrue((boolean)(organizationalEntity2 instanceof GroupImpl));
        Assert.assertEquals((Object)"Project Managers", (Object)organizationalEntity2.getId());
    }

    @Test
    public void testgetNullSafePeopleAssignments() {
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        Assert.assertNotNull((Object)peopleAssignment);
        peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        Assert.assertNotNull((Object)peopleAssignment);
        task.setPeopleAssignments(null);
        peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        Assert.assertNotNull((Object)peopleAssignment);
        Assert.assertEquals((long)0L, (long)peopleAssignment.getPotentialOwners().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getBusinessAdministrators().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getExcludedOwners().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getRecipients().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getTaskStakeholders().size());
    }

    @Test
    public void testHandlePeopleAssignments() {
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        Assert.assertNotNull((Object)peopleAssignment);
        Assert.assertEquals((long)0L, (long)peopleAssignment.getPotentialOwners().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getBusinessAdministrators().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getTaskStakeholders().size());
        String actorId = "espiegelberg";
        String taskStakeholderId = "drmary";
        String businessAdministratorId = "drbug";
        String excludedOwnerId = "john";
        String recipientId = "mary";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        workItem.setParameter("TaskStakeholderId", (Object)taskStakeholderId);
        workItem.setParameter("BusinessAdministratorId", (Object)businessAdministratorId);
        workItem.setParameter("ExcludedOwnerId", (Object)excludedOwnerId);
        workItem.setParameter("RecipientId", (Object)recipientId);
        this.peopleAssignmentHelper.handlePeopleAssignments((WorkItem)workItem, (InternalTask)task, (InternalTaskData)taskData);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        Assert.assertEquals((long)1L, (long)potentialOwners.size());
        Assert.assertEquals((Object)actorId, (Object)((OrganizationalEntity)potentialOwners.get(0)).getId());
        List businessAdministrators = task.getPeopleAssignments().getBusinessAdministrators();
        Assert.assertEquals((long)3L, (long)businessAdministrators.size());
        Assert.assertEquals((Object)"Administrator", (Object)((OrganizationalEntity)businessAdministrators.get(0)).getId());
        Assert.assertEquals((Object)"Administrators", (Object)((OrganizationalEntity)businessAdministrators.get(1)).getId());
        Assert.assertEquals((Object)businessAdministratorId, (Object)((OrganizationalEntity)businessAdministrators.get(2)).getId());
        List taskStakehoders = ((InternalPeopleAssignments)task.getPeopleAssignments()).getTaskStakeholders();
        Assert.assertEquals((long)1L, (long)taskStakehoders.size());
        Assert.assertEquals((Object)taskStakeholderId, (Object)((OrganizationalEntity)taskStakehoders.get(0)).getId());
        List excludedOwners = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        Assert.assertEquals((long)1L, (long)excludedOwners.size());
        Assert.assertEquals((Object)excludedOwnerId, (Object)((OrganizationalEntity)excludedOwners.get(0)).getId());
        List recipients = ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients();
        Assert.assertEquals((long)1L, (long)recipients.size());
        Assert.assertEquals((Object)recipientId, (Object)((OrganizationalEntity)recipients.get(0)).getId());
    }

    @Test
    public void testHandleMultiPeopleAssignments() {
        TaskImpl task = new TaskImpl();
        TaskDataImpl taskData = new TaskDataImpl();
        InternalPeopleAssignments peopleAssignment = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        Assert.assertNotNull((Object)peopleAssignment);
        Assert.assertEquals((long)0L, (long)peopleAssignment.getPotentialOwners().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getBusinessAdministrators().size());
        Assert.assertEquals((long)0L, (long)peopleAssignment.getTaskStakeholders().size());
        String actorId = "espiegelberg,john";
        String taskStakeholderId = "drmary,krisv";
        String businessAdministratorId = "drbug,peter";
        String excludedOwnerId = "john,poul";
        String recipientId = "mary,steve";
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ActorId", (Object)actorId);
        workItem.setParameter("TaskStakeholderId", (Object)taskStakeholderId);
        workItem.setParameter("BusinessAdministratorId", (Object)businessAdministratorId);
        workItem.setParameter("ExcludedOwnerId", (Object)excludedOwnerId);
        workItem.setParameter("RecipientId", (Object)recipientId);
        this.peopleAssignmentHelper.handlePeopleAssignments((WorkItem)workItem, (InternalTask)task, (InternalTaskData)taskData);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        Assert.assertEquals((long)2L, (long)potentialOwners.size());
        Assert.assertEquals((Object)"espiegelberg", (Object)((OrganizationalEntity)potentialOwners.get(0)).getId());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)potentialOwners.get(1)).getId());
        List businessAdministrators = task.getPeopleAssignments().getBusinessAdministrators();
        Assert.assertEquals((long)4L, (long)businessAdministrators.size());
        Assert.assertEquals((Object)"Administrator", (Object)((OrganizationalEntity)businessAdministrators.get(0)).getId());
        Assert.assertEquals((Object)"Administrators", (Object)((OrganizationalEntity)businessAdministrators.get(1)).getId());
        Assert.assertEquals((Object)"drbug", (Object)((OrganizationalEntity)businessAdministrators.get(2)).getId());
        Assert.assertEquals((Object)"peter", (Object)((OrganizationalEntity)businessAdministrators.get(3)).getId());
        List taskStakehoders = ((InternalPeopleAssignments)task.getPeopleAssignments()).getTaskStakeholders();
        Assert.assertEquals((long)2L, (long)taskStakehoders.size());
        Assert.assertEquals((Object)"drmary", (Object)((OrganizationalEntity)taskStakehoders.get(0)).getId());
        Assert.assertEquals((Object)"krisv", (Object)((OrganizationalEntity)taskStakehoders.get(1)).getId());
        List excludedOwners = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        Assert.assertEquals((long)2L, (long)excludedOwners.size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)excludedOwners.get(0)).getId());
        Assert.assertEquals((Object)"poul", (Object)((OrganizationalEntity)excludedOwners.get(1)).getId());
        List recipients = ((InternalPeopleAssignments)task.getPeopleAssignments()).getRecipients();
        Assert.assertEquals((long)2L, (long)recipients.size());
        Assert.assertEquals((Object)"mary", (Object)((OrganizationalEntity)recipients.get(0)).getId());
        Assert.assertEquals((Object)"steve", (Object)((OrganizationalEntity)recipients.get(1)).getId());
    }

    @Test
    public void testAssignExcludedOwners() {
        String excludedOwnerId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("ExcludedOwnerId", (Object)excludedOwnerId);
        this.peopleAssignmentHelper.assignExcludedOwners((WorkItem)workItem, peopleAssignments);
        Assert.assertEquals((long)1L, (long)peopleAssignments.getExcludedOwners().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getExcludedOwners().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)excludedOwnerId, (Object)organizationalEntity1.getId());
    }

    @Test
    public void testAssignRecipients() {
        String recipientId = "espiegelberg";
        TaskImpl task = new TaskImpl();
        InternalPeopleAssignments peopleAssignments = this.peopleAssignmentHelper.getNullSafePeopleAssignments((Task)task);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("RecipientId", (Object)recipientId);
        this.peopleAssignmentHelper.assignRecipients((WorkItem)workItem, peopleAssignments);
        Assert.assertEquals((long)1L, (long)peopleAssignments.getRecipients().size());
        OrganizationalEntity organizationalEntity1 = (OrganizationalEntity)peopleAssignments.getRecipients().get(0);
        Assert.assertTrue((boolean)(organizationalEntity1 instanceof UserImpl));
        Assert.assertEquals((Object)recipientId, (Object)organizationalEntity1.getId());
    }
}

