/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.internals;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskEnvironmentProducer {
    private static final Logger logger = LoggerFactory.getLogger(TaskEnvironmentProducer.class);
    private EntityManagerFactory emf;

    @PersistenceUnit(unitName="org.jbpm.services.task")
    @ApplicationScoped
    @Produces
    public EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        }
        return this.emf;
    }

    @Produces
    @ApplicationScoped
    public EntityManager getEntityManager() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        EntityManager emProxy = (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new EmInvocationHandler(em));
        return emProxy;
    }

    @ApplicationScoped
    public void commitAndClose(@Disposes EntityManager em) {
        try {
            em.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class EmInvocationHandler
    implements InvocationHandler {
        private EntityManager delegate;

        EmInvocationHandler(EntityManager em) {
            this.delegate = em;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.joinTransactionIfNeeded();
            return method.invoke((Object)this.delegate, args);
        }

        private void joinTransactionIfNeeded() {
            try {
                UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                if (ut.getStatus() == 0) {
                    this.delegate.joinTransaction();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

