/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskHandlerHelper {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskHandlerHelper.class);
    private static final String COMPONENT_SEPARATOR = "\\^";
    private static final String ELEMENT_SEPARATOR = "@";
    private static final String ATTRIBUTES_SEPARATOR = "\\|";
    private static final String ATTRIBUTES_ELEMENTS_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String[] KNOWN_KEYS = new String[]{"users", "groups", "from", "tousers", "togroups", "replyto", "subject", "body"};

    public static Deadlines setDeadlines(WorkItem workItem, List<OrganizationalEntity> businessAdministrators, Environment environment) {
        String notStartedReassign = (String)workItem.getParameter("NotStartedReassign");
        String notStartedNotify = (String)workItem.getParameter("NotStartedNotify");
        String notCompletedReassign = (String)workItem.getParameter("NotCompletedReassign");
        String notCompletedNotify = (String)workItem.getParameter("NotCompletedNotify");
        Deadlines deadlinesTotal = TaskModelProvider.getFactory().newDeadlines();
        ArrayList<Deadline> startDeadlines = new ArrayList<Deadline>();
        startDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notStartedNotify, businessAdministrators, environment));
        startDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notStartedReassign, businessAdministrators, environment));
        ArrayList<Deadline> endDeadlines = new ArrayList<Deadline>();
        endDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notCompletedNotify, businessAdministrators, environment));
        endDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notCompletedReassign, businessAdministrators, environment));
        if (!startDeadlines.isEmpty()) {
            deadlinesTotal.setStartDeadlines(startDeadlines);
        }
        if (!endDeadlines.isEmpty()) {
            deadlinesTotal.setEndDeadlines(endDeadlines);
        }
        return deadlinesTotal;
    }

    protected static List<Deadline> parseDeadlineString(String deadlineInfo, List<OrganizationalEntity> businessAdministrators, Environment environment) {
        if (deadlineInfo == null || deadlineInfo.length() == 0) {
            return new ArrayList<Deadline>();
        }
        ArrayList<Deadline> deadlines = new ArrayList<Deadline>();
        String[] allComponents = deadlineInfo.split(COMPONENT_SEPARATOR);
        BusinessCalendar businessCalendar = null;
        if (environment != null && environment.get("jbpm.business.calendar") != null) {
            businessCalendar = (BusinessCalendar)environment.get("jbpm.business.calendar");
        }
        for (String component : allComponents) {
            String[] mainComponents = component.split(ELEMENT_SEPARATOR);
            if (mainComponents != null && mainComponents.length == 2) {
                String actionComponent = mainComponents[0].substring(1, mainComponents[0].length() - 1);
                String expireComponents = mainComponents[1].substring(1, mainComponents[1].length() - 1);
                String[] expireElements = expireComponents.split(ATTRIBUTES_ELEMENTS_SEPARATOR);
                Deadline taskDeadline = null;
                for (String expiresAt : expireElements) {
                    taskDeadline = TaskModelProvider.getFactory().newDeadline();
                    if (businessCalendar != null) {
                        taskDeadline.setDate(businessCalendar.calculateBusinessTimeAsDate(expiresAt));
                    } else {
                        taskDeadline.setDate(new Date(System.currentTimeMillis() + TimeUtils.parseTimeString((String)expiresAt)));
                    }
                    ArrayList<Escalation> escalations = new ArrayList<Escalation>();
                    Escalation escalation = TaskModelProvider.getFactory().newEscalation();
                    escalations.add(escalation);
                    escalation.setName("Default escalation");
                    taskDeadline.setEscalations(escalations);
                    escalation.setReassignments(HumanTaskHandlerHelper.parseReassignment(actionComponent));
                    escalation.setNotifications(HumanTaskHandlerHelper.parseNotifications(actionComponent, businessAdministrators));
                    deadlines.add(taskDeadline);
                }
                continue;
            }
            logger.warn("Incorrect syntax of deadline property {}", (Object)deadlineInfo);
        }
        return deadlines;
    }

    protected static List<Notification> parseNotifications(String notificationString, List<OrganizationalEntity> businessAdministrators) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Map<String, String> parameters = HumanTaskHandlerHelper.asMap(notificationString);
        if (parameters.containsKey("tousers") || parameters.containsKey("togroups")) {
            String groupRecipients;
            String locale = parameters.get("locale");
            if (locale == null) {
                locale = "en-UK";
            }
            EmailNotification emailNotification = TaskModelProvider.getFactory().newEmialNotification();
            notifications.add((Notification)emailNotification);
            emailNotification.setBusinessAdministrators(businessAdministrators);
            HashMap<Language, EmailNotificationHeader> emailHeaders = new HashMap<Language, EmailNotificationHeader>();
            ArrayList<I18NText> subjects = new ArrayList<I18NText>();
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            ArrayList<Object> notificationRecipients = new ArrayList<Object>();
            EmailNotificationHeader emailHeader = TaskModelProvider.getFactory().newEmailNotificationHeader();
            emailHeader.setBody(parameters.get("body"));
            emailHeader.setFrom(parameters.get("from"));
            emailHeader.setReplyTo(parameters.get("replyto"));
            emailHeader.setLanguage(locale);
            emailHeader.setSubject(parameters.get("subject"));
            Language lang = TaskModelProvider.getFactory().newLanguage();
            lang.setMapkey(locale);
            emailHeaders.put(lang, emailHeader);
            I18NText subject = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)subject).setLanguage(locale);
            ((InternalI18NText)subject).setText(emailHeader.getSubject());
            subjects.add(subject);
            names.add(subject);
            String recipients = parameters.get("tousers");
            if (recipients != null && recipients.trim().length() > 0) {
                String[] recipientsIds;
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    User user = TaskModelProvider.getFactory().newUser();
                    ((InternalOrganizationalEntity)user).setId(id.trim());
                    notificationRecipients.add(user);
                }
            }
            if ((groupRecipients = parameters.get("togroups")) != null && groupRecipients.trim().length() > 0) {
                String[] groupRecipientsIds;
                for (String id : groupRecipientsIds = groupRecipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    Group group = TaskModelProvider.getFactory().newGroup();
                    ((InternalOrganizationalEntity)group).setId(id.trim());
                    notificationRecipients.add(group);
                }
            }
            emailNotification.setEmailHeaders(emailHeaders);
            emailNotification.setNames(names);
            emailNotification.setRecipients(notificationRecipients);
            emailNotification.setSubjects(subjects);
        }
        return notifications;
    }

    protected static List<Reassignment> parseReassignment(String reassignString) {
        ArrayList<Reassignment> reassignments = new ArrayList<Reassignment>();
        Map<String, String> parameters = HumanTaskHandlerHelper.asMap(reassignString);
        if (parameters.containsKey("users") || parameters.containsKey("groups")) {
            String[] recipientsIds;
            Reassignment reassignment = TaskModelProvider.getFactory().newReassignment();
            ArrayList<Object> reassignmentUsers = new ArrayList<Object>();
            String recipients = parameters.get("users");
            if (recipients != null && recipients.trim().length() > 0) {
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    User user = TaskModelProvider.getFactory().newUser();
                    ((InternalOrganizationalEntity)user).setId(id.trim());
                    reassignmentUsers.add(user);
                }
            }
            if ((recipients = parameters.get("groups")) != null && recipients.trim().length() > 0) {
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    Group group = TaskModelProvider.getFactory().newGroup();
                    ((InternalOrganizationalEntity)group).setId(id.trim());
                    reassignmentUsers.add(group);
                }
            }
            reassignment.setPotentialOwners(reassignmentUsers);
            reassignments.add(reassignment);
        }
        return reassignments;
    }

    protected static Map<String, String> asMap(String parsableString) {
        String[] actionElements = parsableString.split(ATTRIBUTES_SEPARATOR);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String actionElem : actionElements) {
            for (String knownKey : KNOWN_KEYS) {
                if (!actionElem.startsWith(knownKey)) continue;
                try {
                    parameters.put(knownKey, actionElem.substring(knownKey.length() + KEY_VALUE_SEPARATOR.length()));
                }
                catch (IndexOutOfBoundsException e) {
                    parameters.put(knownKey, "");
                }
            }
        }
        return parameters;
    }
}

