/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.test.MyObject;
import org.jbpm.services.task.test.TestStatefulKnowledgeSession;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.services.task.utils.OnErrorAction;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.model.AccessType;
import org.kie.internal.task.api.model.InternalTaskData;

public abstract class HTWorkItemHandlerBaseTest
extends AbstractBaseTest {
    private static final int DEFAULT_WAIT_TIME = 5000;
    private static final int MANAGER_COMPLETION_WAIT_TIME = 5000;
    private static final int MANAGER_ABORT_WAIT_TIME = 5000;
    private WorkItemHandler handler;
    protected TestStatefulKnowledgeSession ksession;
    protected TaskService taskService;

    @Test
    public void testTask() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        String actualOwner = (String)manager.getResults().get("ActorId");
        Assert.assertNotNull((Object)actualOwner);
        Assert.assertEquals((Object)"Darth Vader", (Object)actualOwner);
    }

    @Test
    public void testTaskMultipleActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader, Dalai Lama");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        this.taskService.claim(task.getId().longValue(), "Darth Vader");
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Luke Cage", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)taskSummary.getName());
        Assert.assertEquals((long)10L, (long)taskSummary.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        PermissionDeniedException denied = null;
        try {
            this.taskService.claim(taskSummary.getId().longValue(), "nocrusadaer");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        Assert.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task = this.taskService.getTaskById(taskSummary.getId().longValue());
        Assert.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
    }

    @Test
    public void testTaskSingleAndGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task One");
        workItem.setParameter("NodeName", (Object)"TaskNameOne");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task Two");
        workItem.setParameter("NodeName", (Object)"TaskNameTwo");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testTaskFail() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.fail(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    @Test
    public void testTaskSkip() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        this.taskService.skip(task.getId().longValue(), "Darth Vader");
        Assert.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    @Test
    public void testTaskExit() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Task task = this.taskService.getTaskByWorkItemId(workItem.getId());
        this.taskService.exit(task.getId().longValue(), "Administrator");
        task = this.taskService.getTaskByWorkItemId(workItem.getId());
        Assert.assertEquals((Object)"TaskName", (Object)((I18NText)task.getNames().get(0)).getText());
        Assert.assertEquals((long)10L, (long)task.getPriority());
        Assert.assertEquals((Object)"Comment", (Object)((I18NText)task.getDescriptions().get(0)).getText());
        Assert.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testTaskExitNonAdministrator() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Task task = this.taskService.getTaskByWorkItemId(workItem.getId());
        try {
            this.taskService.exit(task.getId().longValue(), "Darth Vader");
            Assert.fail((String)"Should not allow to exit task for non administrators");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            // empty catch block
        }
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)taskSummary.getName());
        Assert.assertEquals((long)10L, (long)taskSummary.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)taskSummary.getActualOwner().getId());
    }

    @Test
    public void testTaskAbortSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testTaskAbortNotSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Skippable", (Object)"false");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testTaskData() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Content", (Object)"This is the content");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)taskSummary.getName());
        Assert.assertEquals((long)10L, (long)taskSummary.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)taskSummary.getActualOwner().getId());
        Task task = this.taskService.getTaskById(taskSummary.getId().longValue());
        Assert.assertEquals((Object)AccessType.Inline, (Object)((InternalTaskData)task.getTaskData()).getDocumentAccessType());
        Assert.assertEquals((long)task.getTaskData().getProcessSessionId(), (long)TestStatefulKnowledgeSession.testSessionId.intValue());
        long contentId = task.getTaskData().getDocumentContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Object data = ContentMarshallerHelper.unmarshall((byte[])this.taskService.getContentById(contentId).getContent(), (Environment)this.ksession.getEnvironment());
        Assert.assertEquals((Object)"This is the content", (Object)data);
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        Map<Object, Object> results = new HashMap<String, String>();
        results.put("Result", "This is the result");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", results);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        results = manager.getResults();
        Assert.assertNotNull(results);
        Assert.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        Assert.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    @Test
    public void testTaskDataAutomaticMapping() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        MyObject myObject = new MyObject("MyObjectValue");
        workItem.setParameter("MyObject", (Object)myObject);
        HashMap<String, MyObject> mapParameter = new HashMap<String, MyObject>();
        mapParameter.put("MyObjectInsideTheMap", myObject);
        workItem.setParameter("MyMap", mapParameter);
        workItem.setParameter("MyObject", (Object)myObject);
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)taskSummary.getName());
        Assert.assertEquals((long)10L, (long)taskSummary.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)taskSummary.getActualOwner().getId());
        Task task = this.taskService.getTaskById(taskSummary.getId().longValue());
        Assert.assertEquals((Object)AccessType.Inline, (Object)((InternalTaskData)task.getTaskData()).getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        Assert.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Map data = (Map)ContentMarshallerHelper.unmarshall((byte[])this.taskService.getContentById(contentId).getContent(), (Environment)this.ksession.getEnvironment());
        Assert.assertEquals((Object)"MyObjectValue", (Object)((MyObject)data.get("MyObject")).getValue());
        Assert.assertEquals((Object)"10", data.get("Priority"));
        Assert.assertEquals((Object)"MyObjectValue", (Object)((MyObject)((Map)data.get("MyMap")).get("MyObjectInsideTheMap")).getValue());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        Map<Object, Object> results = new HashMap<String, String>();
        results.put("Result", "This is the result");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", results);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        results = manager.getResults();
        Assert.assertNotNull(results);
        Assert.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        Assert.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    @Test
    public void testTaskCreateFailedWithLog() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        ((AbstractHTWorkItemHandler)this.handler).setAction(OnErrorAction.LOG);
        AddedTaskListener listener = new AddedTaskListener(true);
        ((EventService)this.taskService).registerTaskEventListener((Object)listener);
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"DoesNotExist");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertFalse((boolean)manager.isAborted());
        ((EventService)this.taskService).removeTaskEventListener((Object)listener);
    }

    @Test
    public void testTaskCreateFailedWithAbort() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        AddedTaskListener listener = new AddedTaskListener(true);
        ((EventService)this.taskService).registerTaskEventListener((Object)listener);
        ((AbstractHTWorkItemHandler)this.handler).setAction(OnErrorAction.ABORT);
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"DoesNotExist");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertTrue((boolean)manager.isAborted());
        ((EventService)this.taskService).removeTaskEventListener((Object)listener);
    }

    @Test
    public void testTaskCreateFailedWithRethrow() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        AddedTaskListener listener = new AddedTaskListener(true);
        ((EventService)this.taskService).registerTaskEventListener((Object)listener);
        ((AbstractHTWorkItemHandler)this.handler).setAction(OnErrorAction.RETHROW);
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"DoesNotExist");
        workItem.setProcessInstanceId(10L);
        try {
            this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Should fail due to OnErroAction set to rethrow");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventService)this.taskService).removeTaskEventListener((Object)listener);
    }

    @Test
    public void testTaskWithCreatedBy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("CreatedBy", (Object)"john");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((Object)"john", (Object)task.getCreatedBy().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskWithoutCreatedBy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getCreatedBy().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskWitAutoClaimTaskWithActorAndGroup() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SwimlaneActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskWithAutoClaimTaskWithGroupOnly() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        workItem.setParameter("SwimlaneActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskWithDueDate() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("DueDate", (Object)"2013-11-25T10:35:00Z");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        Assert.assertEquals((long)DateTimeUtils.parseDateTime((String)"2013-11-25T10:35:00Z"), (long)task.getExpirationTime().getTime());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskWithDelay() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("DueDate", (Object)"P2d");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        long currentTime = new Date().getTime();
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getActualOwner().getId());
        Assert.assertEquals((long)10L, (long)task.getProcessInstanceId().intValue());
        Assert.assertTrue((currentTime + DateTimeUtils.parseDuration((String)"2d") > task.getExpirationTime().getTime() ? 1 : 0) != 0);
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    @Test
    public void testTaskCompleteGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        workItem.setProcessInstanceId(10L);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Luke Cage", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)"TaskName", (Object)taskSummary.getName());
        Assert.assertEquals((long)10L, (long)taskSummary.getPriority().intValue());
        Assert.assertEquals((Object)"Comment", (Object)taskSummary.getDescription());
        Assert.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        this.taskService.claim(taskSummary.getId().longValue(), "Luke Cage");
        this.taskService.start(taskSummary.getId().longValue(), "Luke Cage");
        this.taskService.complete(taskSummary.getId().longValue(), "Luke Cage", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        String actualOwner = (String)manager.getResults().get("ActorId");
        Assert.assertNotNull((Object)actualOwner);
        Assert.assertEquals((Object)"Luke Cage", (Object)actualOwner);
    }

    @Test
    public void testTaskWithVariables() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        String taskDescriptionParam = "Comment for task ${task.id} ${task.taskData.processSessionId} ${task.taskData.actualOwner.id} ${task.taskData.parentId}";
        this.handler.executeWorkItem((WorkItem)this.prepareWorkItemWithTaskVariables("Comment for task ${task.id} ${task.taskData.processSessionId} ${task.taskData.actualOwner.id} ${task.taskData.parentId}"), (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task = this.taskService.getTaskById(((TaskSummary)tasks.get(0)).getId().longValue());
        this.testTaskWithExpectedDescription(task, "Comment for task " + task.getId() + " " + task.getTaskData().getProcessSessionId() + " " + task.getTaskData().getActualOwner().getId() + " " + task.getTaskData().getParentId());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        String actualOwner = (String)manager.getResults().get("ActorId");
        Assert.assertNotNull((Object)actualOwner);
        Assert.assertEquals((Object)"Darth Vader", (Object)actualOwner);
    }

    @Test(timeout=10000L)
    public void testTaskWithVariablesRecurse() {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        this.handler.executeWorkItem((WorkItem)this.prepareWorkItemWithTaskVariables("Comment for task ${task.description}"), (WorkItemManager)manager);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        Task task = this.taskService.getTaskById(((TaskSummary)tasks.get(0)).getId().longValue());
        this.testTaskWithExpectedDescription(task, task.getDescription());
        this.taskService.start(task.getId().longValue(), "Darth Vader");
        this.taskService.complete(task.getId().longValue(), "Darth Vader", null);
        Assert.assertTrue((boolean)manager.waitTillCompleted(5000L));
        String actualOwner = (String)manager.getResults().get("ActorId");
        Assert.assertNotNull((Object)actualOwner);
        Assert.assertEquals((Object)"Darth Vader", (Object)actualOwner);
    }

    private WorkItemImpl prepareWorkItemWithTaskVariables(String taskDescriptionParam) {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("NodeName", (Object)"TaskName ${task.taskData.processInstanceId}");
        workItem.setParameter("Comment", (Object)taskDescriptionParam);
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        return workItem;
    }

    private void testTaskWithExpectedDescription(Task task, String expectedDescription) {
        Assert.assertEquals((Object)("TaskName " + task.getTaskData().getProcessInstanceId()), (Object)task.getName());
        Assert.assertEquals((long)10L, (long)task.getPriority());
        Assert.assertEquals((Object)expectedDescription, (Object)task.getDescription());
        Assert.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        Assert.assertEquals((Object)"Darth Vader", (Object)task.getTaskData().getActualOwner().getId());
        Assert.assertEquals((long)10L, (long)task.getTaskData().getProcessInstanceId());
    }

    public void setHandler(WorkItemHandler handler) {
        this.handler = handler;
    }

    public WorkItemHandler getHandler() {
        return this.handler;
    }

    public static class AddedTaskListener
    extends DefaultTaskEventListener {
        private boolean throwException = false;

        public AddedTaskListener() {
        }

        public AddedTaskListener(boolean throwException) {
            this.throwException = throwException;
        }

        public boolean isThrowException() {
            return this.throwException;
        }

        public void setThrowException(boolean throwException) {
            this.throwException = throwException;
        }

        public void afterTaskAddedEvent(TaskEvent event) {
            if (this.isThrowException()) {
                throw new RuntimeException("test exception");
            }
        }
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile Map<String, Object> results;

        private TestWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

