/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.ClassObjectFilter;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.services.task.utils.OnErrorAction;
import org.jbpm.services.task.wih.util.HumanTaskHandlerHelper;
import org.jbpm.services.task.wih.util.PeopleAssignmentHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHTWorkItemHandler.class);
    protected OnErrorAction action = OnErrorAction.LOG;

    public AbstractHTWorkItemHandler() {
    }

    public AbstractHTWorkItemHandler(OnErrorAction action) {
        this.action = action;
    }

    public void setAction(OnErrorAction action) {
        this.action = action;
    }

    protected Task createTaskBasedOnWorkItemParams(KieSession session, WorkItem workItem) {
        String createdBy;
        String description;
        String comment;
        InternalTask task = (InternalTask)TaskModelProvider.getFactory().newTask();
        String taskName = (String)workItem.getParameter("NodeName");
        CaseData caseFile = null;
        String locale = (String)workItem.getParameter("Locale");
        if (locale == null) {
            locale = "en-UK";
        }
        if (taskName != null) {
            ArrayList<I18NText> names = new ArrayList<I18NText>();
            I18NText text = TaskModelProvider.getFactory().newI18NText();
            ((InternalI18NText)text).setLanguage(locale);
            ((InternalI18NText)text).setText(taskName);
            names.add(text);
            task.setNames(names);
        }
        task.setName(taskName);
        String formName = (String)workItem.getParameter("TaskName");
        if (formName != null) {
            task.setFormName(formName);
        }
        if ((comment = (String)workItem.getParameter("Comment")) == null) {
            comment = "";
        }
        if ((description = (String)workItem.getParameter("Description")) == null) {
            description = comment;
        }
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        I18NText descText = TaskModelProvider.getFactory().newI18NText();
        ((InternalI18NText)descText).setLanguage(locale);
        ((InternalI18NText)descText).setText(description);
        descriptions.add(descText);
        task.setDescriptions(descriptions);
        task.setDescription(description);
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        I18NText subjectText = TaskModelProvider.getFactory().newI18NText();
        ((InternalI18NText)subjectText).setLanguage(locale);
        ((InternalI18NText)subjectText).setText(comment);
        subjects.add(subjectText);
        task.setSubjects(subjects);
        task.setSubject(comment);
        String priorityString = (String)workItem.getParameter("Priority");
        int priority = 0;
        if (priorityString != null) {
            try {
                priority = new Integer(priorityString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        task.setPriority(priority);
        InternalTaskData taskData = (InternalTaskData)TaskModelProvider.getFactory().newTaskData();
        taskData.setWorkItemId(workItem.getId());
        taskData.setProcessInstanceId(workItem.getProcessInstanceId());
        if (session != null) {
            Collection caseFiles;
            if (session.getProcessInstance(workItem.getProcessInstanceId()) != null) {
                taskData.setProcessId(session.getProcessInstance(workItem.getProcessInstanceId()).getProcess().getId());
                String deploymentId = ((WorkItemImpl)workItem).getDeploymentId();
                taskData.setDeploymentId(deploymentId);
            }
            if (session instanceof KieSession) {
                taskData.setProcessSessionId(session.getIdentifier());
            }
            if ((caseFiles = session.getObjects((ObjectFilter)new ClassObjectFilter(CaseData.class))) != null && caseFiles.size() == 1) {
                caseFile = (CaseData)caseFiles.iterator().next();
            }
        }
        taskData.setSkipable(!"false".equals(workItem.getParameter("Skippable")));
        Long parentId = (Long)workItem.getParameter("ParentId");
        if (parentId != null) {
            taskData.setParentId(parentId.longValue());
        }
        if ((createdBy = (String)workItem.getParameter("CreatedBy")) != null && createdBy.trim().length() > 0) {
            User user = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)user).setId(createdBy);
            taskData.setCreatedBy(user);
        }
        String dueDateString = (String)workItem.getParameter("DueDate");
        Date date = null;
        if (dueDateString != null && !dueDateString.isEmpty()) {
            if (DateTimeUtils.isPeriod((String)dueDateString)) {
                Long longDateValue = DateTimeUtils.parseDateAsDuration((String)dueDateString.substring(1));
                date = new Date(System.currentTimeMillis() + longDateValue);
            } else {
                date = new Date(DateTimeUtils.parseDateTime((String)dueDateString));
            }
        }
        if (date != null) {
            taskData.setExpirationTime(date);
        }
        PeopleAssignmentHelper peopleAssignmentHelper = new PeopleAssignmentHelper(caseFile);
        peopleAssignmentHelper.handlePeopleAssignments(workItem, task, taskData);
        PeopleAssignments peopleAssignments = task.getPeopleAssignments();
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        taskData.initialize();
        task.setTaskData((TaskData)taskData);
        task.setDeadlines(HumanTaskHandlerHelper.setDeadlines(workItem, businessAdministrators, session.getEnvironment()));
        return task;
    }

    protected ContentData createTaskContentBasedOnWorkItemParams(KieSession session, WorkItem workItem) {
        ContentData content = null;
        HashMap contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            contentObject = new HashMap(workItem.getParameters());
        }
        if (contentObject != null) {
            Environment env = null;
            if (session != null) {
                env = session.getEnvironment();
            }
            content = ContentMarshallerHelper.marshal(null, contentObject, (Environment)env);
        }
        return content;
    }

    protected Map<String, Object> createTaskDataBasedOnWorkItemParams(KieSession session, WorkItem workItem) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Object contentObject = workItem.getParameter("Content");
        if (contentObject == null) {
            data = new HashMap(workItem.getParameters());
        } else {
            data.put("Content", contentObject);
        }
        return data;
    }

    protected boolean isAutoClaim(WorkItem workItem, Task task) {
        String swimlaneUser = (String)workItem.getParameter("SwimlaneActorId");
        return swimlaneUser != null && !"".equals(swimlaneUser) && task.getTaskData().getStatus() == Status.Ready;
    }

    public abstract void executeWorkItem(WorkItem var1, WorkItemManager var2);

    public abstract void abortWorkItem(WorkItem var1, WorkItemManager var2);
}

