/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.services.task.wih.util.HumanTaskHandlerHelper;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;

public class HumanTaskHandlerHelperTest
extends AbstractBaseTest {
    @Test
    public void testSetDeadlinesNotStartedReassign() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithGroups() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john|groups:sales]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignTwoTimes() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[4h,6h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassign() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithGroups() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john|groups:sales]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignTwoTimes() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[4h,6h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getEndDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimal() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyAllElements() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[from:mike|tousers:john,mary|togroups:sales,hr|replyto:mike|subject:Test of notification|body:And here is the body]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)4L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"mary", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)notification.getRecipients().get(2)).getId());
        Assert.assertEquals((Object)"hr", (Object)((OrganizationalEntity)notification.getRecipients().get(3)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertEquals((Object)"mike", (Object)header.getFrom());
        Assert.assertEquals((Object)"mike", (Object)header.getReplyTo());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalMultipleExpirations() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[4h,6h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithHtml() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:&lt;html&gt;&lt;body&gt;Reason {s}&lt;br/&gt;body of notification:&lt;br/&gt;work item id - ${workItemId}&lt;br/&gt;process instance id - ${processInstanceId}&lt;br/&gt;task id - ${taskId}&lt;br/&gt;http://localhost:8080/taskserver-urlexpiration time - ${doc['Deadlines'][0].expires}&lt;br/&gt;&lt;/body&gt;&lt;/html&gt;]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((WorkItem)workItem, (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertTrue((header.getBody().indexOf("http://localhost:8080/taskserver-url") != -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    private long roundExpirationTime(long expirationTime) {
        BigDecimal a = new BigDecimal(expirationTime);
        a = a.setScale(1, 1);
        BigDecimal b = new BigDecimal(3600000);
        b = b.setScale(1, 1);
        double devided = a.doubleValue() / b.doubleValue();
        long roundedValue = Math.round(devided);
        return roundedValue;
    }
}

