/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.Date;
import java.util.Map;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.utils.OnErrorAction;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.exception.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHTWorkItemHandler
extends AbstractHTWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalHTWorkItemHandler.class);
    private RuntimeManager runtimeManager;

    public RuntimeManager getRuntimeManager() {
        return this.runtimeManager;
    }

    public void setRuntimeManager(RuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    @Override
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        block9: {
            RuntimeEngine runtime = this.runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
            KieSession ksessionById = runtime.getKieSession();
            Task task = this.createTaskBasedOnWorkItemParams(ksessionById, workItem);
            Map<String, Object> content = this.createTaskDataBasedOnWorkItemParams(ksessionById, workItem);
            try {
                long taskId = ((InternalTaskService)runtime.getTaskService()).addTask(task, content);
                if (this.isAutoClaim(workItem, task)) {
                    try {
                        runtime.getTaskService().claim(taskId, (String)workItem.getParameter("SwimlaneActorId"));
                    }
                    catch (PermissionDeniedException e) {
                        logger.warn("User {} is not allowed to auto claim task due to permission violation", workItem.getParameter("SwimlaneActorId"));
                    }
                }
            }
            catch (Exception e) {
                if (this.action.equals((Object)OnErrorAction.ABORT)) {
                    manager.abortWorkItem(workItem.getId());
                }
                if (this.action.equals((Object)OnErrorAction.RETHROW)) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                if (!this.action.equals((Object)OnErrorAction.LOG)) break block9;
                StringBuilder logMsg = new StringBuilder();
                logMsg.append(new Date()).append(": Error when creating task on task server for work item id ").append(workItem.getId());
                logMsg.append(". Error reported by task server: ").append(e.getMessage());
                logger.error(logMsg.toString(), (Throwable)e);
                if (e instanceof TaskException && (!(e instanceof TaskException) || ((TaskException)e).isRecoverable())) break block9;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        RuntimeEngine runtime = this.runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)workItem.getProcessInstanceId()));
        Task task = runtime.getTaskService().getTaskByWorkItemId(workItem.getId());
        if (task != null) {
            try {
                runtime.getTaskService().exit(task.getId().longValue(), "Administrator");
            }
            catch (PermissionDeniedException e) {
                logger.info(e.getMessage());
            }
        }
    }
}

