/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.test.TestStatefulKnowledgeSession;
import org.jbpm.services.task.wih.HTWorkItemHandlerBaseTest;
import org.jbpm.services.task.wih.NonManagedLocalHTWorkItemHandler;
import org.junit.After;
import org.junit.Before;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.task.api.InternalTaskService;

public class HTWorkItemHandlerTest
extends HTWorkItemHandlerBaseTest {
    private EntityManagerFactory emf;
    private WorkItemHandler htWorkItemHandler;
    private PoolingDataSource pds;

    @Before
    public void setUp() throws Exception {
        this.pds = this.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        this.ksession = new TestStatefulKnowledgeSession();
        this.ksession.setEnvironment(EnvironmentFactory.newEnvironment());
        this.taskService = (InternalTaskService)HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).getTaskService();
        this.htWorkItemHandler = new NonManagedLocalHTWorkItemHandler((KieSession)this.ksession, this.taskService);
        this.setHandler(this.htWorkItemHandler);
    }

    @After
    public void tearDown() throws Exception {
        int removeAllTasks = ((InternalTaskService)this.taskService).removeAllTasks();
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    protected PoolingDataSource setupPoolingDataSource() {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/jbpm-ds");
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.setMaxPoolSize(5);
        pds.setAllowLocalTransactions(true);
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("password", "");
        pds.getDriverProperties().put("url", "jdbc:h2:mem:jbpm-db;MVCC=true");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        return pds;
    }
}

