/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.services.task.impl.util.HumanTaskHandlerHelper;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;

public class HumanTaskHandlerHelperTest
extends AbstractBaseTest {
    @Test
    public void testSetDeadlinesNotStartedReassign() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)("[users:john]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testToEmailsNotStarted() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[toemails:salaboy@unkown.com,krisv@unknown.com]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertEquals((long)2L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"salaboy@unkown.com", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"krisv@unknown.com", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
    }

    @Test
    public void testToEmailsNotCompleted() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedNotify", (Object)"[toemails:salaboy@unkown.com,krisv@unknown.com]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)3L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertEquals((long)2L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"salaboy@unkown.com", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"krisv@unknown.com", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithISOExpirationTimePeriodFormatWithStartEnd() {
        String currentFormatted = OffsetDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)("[users:john]@[R3/" + currentFormatted + "/" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)(i * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithISOExpirationTimeWithPeriodStartEnd() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)("[users:john]@[R3/PT2S/" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithGroups() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john|groups:sales]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithGroupsWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)("[users:john|groups:sales]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithGroupsWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john|groups:sales]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignWithGroupsWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john|groups:sales]@[R5/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)5L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        for (int i = 0; i < 5; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testSetDeadlinesNotStartedReassignTwoTimes() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[4h,6h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignTwoTimesWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        OffsetDateTime sixHoursFromNow = OffsetDateTime.now().plusHours(6L);
        String sixHoursFromNowFormatted = sixHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)("[users:john]@[" + fourHoursFromNowFormatted + "," + sixHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignTwoTimesWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[PT4H,PT6H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotStartedReassignTwoTimesWithISOExpirationTimePeriodFormatWithRepeatCount() {
        long expirationTime;
        int i;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedReassign", (Object)"[users:john]@[R3/PT4H,R3/PT6H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)6L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (i = 3; i < 6; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i - 3 + 1) * 6), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testSetDeadlinesNotCompletedReassign() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)("[users:john]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithGroups() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john|groups:sales]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithGroupsWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)("[users:john|groups:sales]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithGroupsWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john|groups:sales]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignWithGroupsWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john|groups:sales]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)2L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(1)).getId());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignTwoTimes() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[4h,6h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getEndDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignTwoTimesWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        OffsetDateTime sixHoursFromNow = OffsetDateTime.now().plusHours(6L);
        String sixHoursFromNowFormatted = sixHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)("[users:john]@[" + fourHoursFromNowFormatted + "," + sixHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getEndDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignTwoTimesWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[PT4H,PT6H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getEndDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testSetDeadlinesNotCompletedReassignTwoTimesWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotCompletedReassign", (Object)"[users:john]@[R/PT4H,R3/PT6H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)4L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getNotifications().size());
        Reassignment reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(0)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getEndDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        reassignment = (Reassignment)((Escalation)((Deadline)deadlines.getEndDeadlines().get(1)).getEscalations().get(0)).getReassignments().get(0);
        Assert.assertEquals((long)1L, (long)reassignment.getPotentialOwners().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)reassignment.getPotentialOwners().get(0)).getId());
        for (int i = 1; i < 4; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getEndDeadlines().get(i)).getDate());
            expirationTime = ((Deadline)deadlines.getEndDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i - 1 + 1) * 6), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testNotStartedNotifyMinimal() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)("[tousers:john|subject:Test of notification|body:And here is the body]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testNotStartedNotifyAllElements() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[from:mike|tousers:john,mary|togroups:sales,hr|replyto:mike|subject:Test of notification|body:And here is the body]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)4L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"mary", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)notification.getRecipients().get(2)).getId());
        Assert.assertEquals((Object)"hr", (Object)((OrganizationalEntity)notification.getRecipients().get(3)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertEquals((Object)"mike", (Object)header.getFrom());
        Assert.assertEquals((Object)"mike", (Object)header.getReplyTo());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyAllElementsWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)("[from:mike|tousers:john,mary|togroups:sales,hr|replyto:mike|subject:Test of notification|body:And here is the body]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)4L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"mary", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)notification.getRecipients().get(2)).getId());
        Assert.assertEquals((Object)"hr", (Object)((OrganizationalEntity)notification.getRecipients().get(3)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertEquals((Object)"mike", (Object)header.getFrom());
        Assert.assertEquals((Object)"mike", (Object)header.getReplyTo());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyAllElementsWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[from:mike|tousers:john,mary|togroups:sales,hr|replyto:mike|subject:Test of notification|body:And here is the body]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)4L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"mary", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)notification.getRecipients().get(2)).getId());
        Assert.assertEquals((Object)"hr", (Object)((OrganizationalEntity)notification.getRecipients().get(3)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertEquals((Object)"mike", (Object)header.getFrom());
        Assert.assertEquals((Object)"mike", (Object)header.getReplyTo());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyAllElementsWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[from:mike|tousers:john,mary|togroups:sales,hr|replyto:mike|subject:Test of notification|body:And here is the body]@[R3/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)3L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)4L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((Object)"mary", (Object)((OrganizationalEntity)notification.getRecipients().get(1)).getId());
        Assert.assertEquals((Object)"sales", (Object)((OrganizationalEntity)notification.getRecipients().get(2)).getId());
        Assert.assertEquals((Object)"hr", (Object)((OrganizationalEntity)notification.getRecipients().get(3)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertEquals((Object)"mike", (Object)header.getFrom());
        Assert.assertEquals((Object)"mike", (Object)header.getReplyTo());
        for (int i = 0; i < 3; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testNotStartedNotifyMinimalMultipleExpirations() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[4h,6h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalMultipleExpirationsWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        OffsetDateTime sixHoursFromNow = OffsetDateTime.now().plusHours(6L);
        String sixHoursFromNowFormatted = sixHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)("[tousers:john|subject:Test of notification|body:And here is the body]@[" + fourHoursFromNowFormatted + "," + sixHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalMultipleExpirationsWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[PT4H,PT6H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
        notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(1)).getDate());
        expirationTime = ((Deadline)deadlines.getStartDeadlines().get(1)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)6L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalMultipleExpirationsWithISOExpirationTimePeriodFormatWithRepeatCount() {
        long expirationTime;
        int i;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:And here is the body]@[R4/PT4H,R4/PT6H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)8L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        for (i = 0; i < 4; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
        notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(1)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertEquals((Object)"And here is the body", (Object)header.getBody());
        for (i = 4; i < 8; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i - 4 + 1) * 6), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testNotStartedNotifyMinimalWithHtml() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:&lt;html&gt;&lt;body&gt;Reason {s}&lt;br/&gt;body of notification:&lt;br/&gt;work item id - ${workItemId}&lt;br/&gt;process instance id - ${processInstanceId}&lt;br/&gt;task id - ${taskId}&lt;br/&gt;http://localhost:8080/taskserver-urlexpiration time - ${doc['Deadlines'][0].expires}&lt;br/&gt;&lt;/body&gt;&lt;/html&gt;]@[4h]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertTrue((header.getBody().indexOf("http://localhost:8080/taskserver-url") != -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithHtmlWithISOExpirationTime() {
        OffsetDateTime fourHoursFromNow = OffsetDateTime.now().plusHours(4L);
        String fourHoursFromNowFormatted = fourHoursFromNow.format(DateTimeFormatter.ISO_DATE_TIME);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)("[tousers:john|subject:Test of notification|body:&lt;html&gt;&lt;body&gt;Reason {s}&lt;br/&gt;body of notification:&lt;br/&gt;work item id - ${workItemId}&lt;br/&gt;process instance id - ${processInstanceId}&lt;br/&gt;task id - ${taskId}&lt;br/&gt;http://localhost:8080/taskserver-urlexpiration time - ${doc['Deadlines'][0].expires}&lt;br/&gt;&lt;/body&gt;&lt;/html&gt;]@[" + fourHoursFromNowFormatted + "]"));
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertTrue((header.getBody().indexOf("http://localhost:8080/taskserver-url") != -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithHtmlWithISOExpirationTimePeriodFormat() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:&lt;html&gt;&lt;body&gt;Reason {s}&lt;br/&gt;body of notification:&lt;br/&gt;work item id - ${workItemId}&lt;br/&gt;process instance id - ${processInstanceId}&lt;br/&gt;task id - ${taskId}&lt;br/&gt;http://localhost:8080/taskserver-urlexpiration time - ${doc['Deadlines'][0].expires}&lt;br/&gt;&lt;/body&gt;&lt;/html&gt;]@[PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)1L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertTrue((header.getBody().indexOf("http://localhost:8080/taskserver-url") != -1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(0)).getDate());
        long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(0)).getDate().getTime() - System.currentTimeMillis();
        Assert.assertEquals((long)4L, (long)this.roundExpirationTime(expirationTime));
    }

    @Test
    public void testNotStartedNotifyMinimalWithHtmlWithISOExpirationTimePeriodFormatWithRepeatCount() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("NotStartedNotify", (Object)"[tousers:john|subject:Test of notification|body:&lt;html&gt;&lt;body&gt;Reason {s}&lt;br/&gt;body of notification:&lt;br/&gt;work item id - ${workItemId}&lt;br/&gt;process instance id - ${processInstanceId}&lt;br/&gt;task id - ${taskId}&lt;br/&gt;http://localhost:8080/taskserver-urlexpiration time - ${doc['Deadlines'][0].expires}&lt;br/&gt;&lt;/body&gt;&lt;/html&gt;]@[R2/PT4H]");
        Deadlines deadlines = HumanTaskHandlerHelper.setDeadlines((Map)workItem.getParameters(), (List)Collections.EMPTY_LIST, null);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.getStartDeadlines().size());
        Assert.assertEquals((long)0L, (long)deadlines.getEndDeadlines().size());
        Assert.assertEquals((long)1L, (long)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().size());
        Assert.assertEquals((long)1L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().size());
        Assert.assertEquals((long)0L, (long)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getReassignments().size());
        Notification notification = (Notification)((Escalation)((Deadline)deadlines.getStartDeadlines().get(0)).getEscalations().get(0)).getNotifications().get(0);
        Assert.assertNotNull((Object)notification);
        Assert.assertEquals((long)1L, (long)notification.getRecipients().size());
        Assert.assertEquals((Object)"john", (Object)((OrganizationalEntity)notification.getRecipients().get(0)).getId());
        Assert.assertEquals((long)1L, (long)notification.getSubjects().size());
        Assert.assertEquals((Object)"Test of notification", (Object)((I18NText)notification.getSubjects().get(0)).getText());
        EmailNotification emailNotification = (EmailNotification)notification;
        Assert.assertEquals((long)1L, (long)emailNotification.getEmailHeaders().size());
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey("en-UK");
        EmailNotificationHeader header = (EmailNotificationHeader)emailNotification.getEmailHeaders().get(lang);
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Test of notification", (Object)header.getSubject());
        Assert.assertTrue((header.getBody().indexOf("http://localhost:8080/taskserver-url") != -1 ? 1 : 0) != 0);
        for (int i = 0; i < 2; ++i) {
            Assert.assertNotNull((Object)((Deadline)deadlines.getStartDeadlines().get(i)).getDate());
            long expirationTime = ((Deadline)deadlines.getStartDeadlines().get(i)).getDate().getTime() - System.currentTimeMillis();
            Assert.assertEquals((long)((i + 1) * 4), (long)this.roundExpirationTime(expirationTime));
        }
    }

    @Test
    public void testparseDeadlineStringRepeatDuration() {
        long currentTimeInMillis = System.currentTimeMillis();
        String repeatable1 = "[users:john]@[R2/PT4H]";
        List deadlines = HumanTaskHandlerHelper.parseDeadlineString((String)repeatable1, null, null, (boolean)false);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.size());
        long firstDiff = Math.abs(((Deadline)deadlines.get(0)).getDate().getTime() - currentTimeInMillis);
        long firstDiffHours = TimeUnit.HOURS.convert(firstDiff, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)4L, (long)firstDiffHours);
        long secondDiff = Math.abs(((Deadline)deadlines.get(1)).getDate().getTime() - ((Deadline)deadlines.get(0)).getDate().getTime());
        long secondDiffHours = TimeUnit.HOURS.convert(secondDiff, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)4L, (long)secondDiffHours);
    }

    @Test
    public void testparseDeadlineStringRepeatStartDuration() {
        String repeatable1 = "[users:john]@[R2/2019-05-27T13:00:00Z/PT4H]";
        List deadlines = HumanTaskHandlerHelper.parseDeadlineString((String)repeatable1, null, null, (boolean)false);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.size());
        long diff = Math.abs(((Deadline)deadlines.get(1)).getDate().getTime() - ((Deadline)deadlines.get(0)).getDate().getTime());
        long diffHours = TimeUnit.HOURS.convert(diff, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)diffHours, (long)4L);
    }

    @Test
    public void testparseDeadlineStringDurationEnd() {
        String repeatable1 = "[users:john]@[R2/PT4H/2019-05-27T13:00:00Z]";
        List deadlines = HumanTaskHandlerHelper.parseDeadlineString((String)repeatable1, null, null, (boolean)false);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.size());
        long diff = Math.abs(((Deadline)deadlines.get(1)).getDate().getTime() - ((Deadline)deadlines.get(0)).getDate().getTime());
        long diffHours = TimeUnit.HOURS.convert(diff, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)diffHours, (long)4L);
    }

    @Test
    public void testparseDeadlineStringStartEnd() {
        String repeatable1 = "[users:john]@[R2/2019-05-27T13:00:00Z/2019-05-27T17:00:00Z]";
        List deadlines = HumanTaskHandlerHelper.parseDeadlineString((String)repeatable1, null, null, (boolean)false);
        Assert.assertNotNull((Object)deadlines);
        Assert.assertEquals((long)2L, (long)deadlines.size());
        long diff = Math.abs(((Deadline)deadlines.get(1)).getDate().getTime() - ((Deadline)deadlines.get(0)).getDate().getTime());
        long diffHours = TimeUnit.HOURS.convert(diff, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)diffHours, (long)4L);
    }

    private long roundExpirationTime(long expirationTime) {
        BigDecimal a = new BigDecimal(expirationTime);
        a = a.setScale(1, 1);
        BigDecimal b = new BigDecimal(3600000);
        b = b.setScale(1, 1);
        double devided = a.doubleValue() / b.doubleValue();
        long roundedValue = Math.round(devided);
        return roundedValue;
    }
}

