/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.test.TestStatefulKnowledgeSession;
import org.jbpm.services.task.wih.HTWorkItemHandlerBaseTest;
import org.jbpm.services.task.wih.NonManagedLocalHTWorkItemHandler;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.After;
import org.junit.Before;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class HTWorkItemHandlerTest
extends HTWorkItemHandlerBaseTest {
    private EntityManagerFactory emf;
    private PoolingDataSourceWrapper pds;

    @Before
    public void setUp() throws Exception {
        this.pds = this.setupPoolingDataSource();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        this.ksession = new TestStatefulKnowledgeSession();
        this.env = EnvironmentFactory.newEnvironment();
        this.ksession.setEnvironment(this.env);
        this.taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).getTaskService();
        NonManagedLocalHTWorkItemHandler htWorkItemHandler = new NonManagedLocalHTWorkItemHandler((KieSession)this.ksession, this.taskService);
        this.setHandler((WorkItemHandler)htWorkItemHandler);
    }

    @After
    public void tearDown() throws Exception {
        ((InternalTaskService)this.taskService).removeAllTasks();
        if (this.emf != null) {
            this.emf.close();
        }
        if (this.pds != null) {
            this.pds.close();
        }
    }

    protected PoolingDataSourceWrapper setupPoolingDataSource() {
        return PersistenceUtil.setupPoolingDataSource((String)"jdbc/jbpm-ds");
    }
}

