/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.process.workitem.wsht.MyObject;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.I18NText;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TestStatefulKnowledgeSession;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public abstract class WSHumanTaskHandlerBaseTest
extends BaseTest {
    private static final int DEFAULT_WAIT_TIME = 5000;
    private static final int MANAGER_COMPLETION_WAIT_TIME = 5000;
    private static final int MANAGER_ABORT_WAIT_TIME = 5000;
    private TaskClient client;
    private WorkItemHandler handler;

    public void setClient(TaskClient client) {
        this.client = client;
    }

    public TaskClient getClient() {
        return this.client;
    }

    public void testTask() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        WSHumanTaskHandlerBaseTest.assertEquals((long)10L, (long)task.getProcessInstanceId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(15000L);
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void testTaskMultipleActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader, Dalai Lama");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().claim(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().complete(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void testTaskGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        this.getClient().getTasksAssignedAsPotentialOwner(null, groupIds, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().claim(taskSummary.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        PermissionDeniedException denied = null;
        try {
            operationResponseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        WSHumanTaskHandlerBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
    }

    public void testTaskSingleAndGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task One");
        workItem.setParameter("TaskName", (Object)"TaskNameOne");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task Two");
        workItem.setParameter("TaskName", (Object)"TaskNameTwo");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", groupIds, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testTaskFail() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().fail(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    public void testTaskSkip() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().skip(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    public void testTaskExit() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().exit(task.getId(), "Administrator", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task taskInstance = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)((I18NText)taskInstance.getNames().get(0)).getText());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Exited, (Object)taskInstance.getTaskData().getStatus());
    }

    public void testTaskAbortSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskAbortNotSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Skippable", (Object)"false");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskData() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Content", (Object)"This is the content");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        WSHumanTaskHandlerBaseTest.assertEquals((int)task.getTaskData().getProcessSessionId(), (int)TestStatefulKnowledgeSession.testSessionId);
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerBaseTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.getClient().getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        ByteArrayInputStream bis = new ByteArrayInputStream(getContentResponseHandler.getContent().getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Object data = in.readObject();
        in.close();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)"This is the content", (Object)data);
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.getClient().complete(task.getId().longValue(), "Darth Vader", result, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerBaseTest.assertNotNull(results);
        WSHumanTaskHandlerBaseTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerBaseTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void testTaskDataAutomaticMapping() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        MyObject myObject = new MyObject("MyObjectValue");
        workItem.setParameter("MyObject", (Object)myObject);
        HashMap<String, MyObject> mapParameter = new HashMap<String, MyObject>();
        mapParameter.put("MyObjectInsideTheMap", myObject);
        workItem.setParameter("MyMap", mapParameter);
        workItem.setParameter("MyObject", (Object)myObject);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(taskSummary.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerBaseTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.getClient().getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        ByteArrayInputStream bis = new ByteArrayInputStream(getContentResponseHandler.getContent().getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Map data = (Map)in.readObject();
        in.close();
        WSHumanTaskHandlerBaseTest.assertEquals((String)"MyObjectValue", (String)((MyObject)data.get("MyObject")).getValue());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)"10", data.get("Priority"));
        WSHumanTaskHandlerBaseTest.assertEquals((String)"MyObjectValue", (String)((MyObject)((Map)data.get("MyMap")).get("MyObjectInsideTheMap")).getValue());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.getClient().complete(task.getId().longValue(), "Darth Vader", result, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerBaseTest.assertNotNull(results);
        WSHumanTaskHandlerBaseTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerBaseTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void TODOtestOnAllSubTasksEndParentEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnAllSubTasksEndParentEnd");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerBaseTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerBaseTest.assertNotNull((Object)subTaskSummary2);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary1.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary2.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().complete(subTask1.getId().longValue(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().complete(subTask2.getId().longValue(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTask1.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTask2.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(parentTask.getId().longValue(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Completed, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void TODOtestOnParentAbortAllSubTasksEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnParentAbortAllSubTasksEnd");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerBaseTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(task.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task parentTask = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.getClient().getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List subTasks = responseHandler.getResults();
        WSHumanTaskHandlerBaseTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerBaseTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerBaseTest.assertNotNull((Object)subTaskSummary2);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary1.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().start(subTaskSummary2.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.getClient().skip(parentTask.getId().longValue(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary1.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask1 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.getClient().getTask(subTaskSummary2.getId(), (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        subTask2 = getTaskResponseHandler.getTask();
        WSHumanTaskHandlerBaseTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        WSHumanTaskHandlerBaseTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void setHandler(WorkItemHandler handler) {
        this.handler = handler;
    }

    public WorkItemHandler getHandler() {
        return this.handler;
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile Map<String, Object> results;

        private TestWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

