/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht.hornetq.async;

import org.drools.SystemEventListenerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.workitem.wsht.AsyncWSHumanTaskHandler;
import org.jbpm.process.workitem.wsht.async.WSHumanTaskHandlerBaseAsyncTest;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.TestStatefulKnowledgeSession;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.hornetq.HornetQTaskClientConnector;
import org.jbpm.task.service.hornetq.HornetQTaskClientHandler;
import org.jbpm.task.service.hornetq.HornetQTaskServer;

public class WSHumanTaskHandlerHornetQAsyncTest
extends WSHumanTaskHandlerBaseAsyncTest {
    private TaskServer server;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.server = new HornetQTaskServer(this.taskService, 5446);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        logger.debug("Waiting for the HornetQTask Server to come up");
        while (!this.server.isRunning()) {
            Thread.sleep(50L);
        }
        this.setClient((AsyncTaskService)new TaskClient((TaskClientConnector)new HornetQTaskClientConnector("client 1", (BaseClientHandler)new HornetQTaskClientHandler(SystemEventListenerFactory.getSystemEventListener()))));
        TestStatefulKnowledgeSession ksession = new TestStatefulKnowledgeSession();
        AsyncWSHumanTaskHandler handler = new AsyncWSHumanTaskHandler(this.getClient(), (KnowledgeRuntime)ksession);
        handler.setConnection("127.0.0.1", 5446);
        this.setHandler((WorkItemHandler)handler);
        this.setSession(ksession);
    }

    @Override
    protected void tearDown() throws Exception {
        ((AsyncWSHumanTaskHandler)this.getHandler()).dispose();
        this.getClient().disconnect();
        this.server.stop();
        super.tearDown();
    }
}

