/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht.sync;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.process.workitem.wsht.MyObject;
import org.jbpm.process.workitem.wsht.SyncWSHumanTaskHandler;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.I18NText;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.TestStatefulKnowledgeSession;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.utils.OnErrorAction;

public abstract class WSHumanTaskHandlerBaseSyncTest
extends BaseTest {
    private static final int DEFAULT_WAIT_TIME = 5000;
    private static final int MANAGER_COMPLETION_WAIT_TIME = 5000;
    private static final int MANAGER_ABORT_WAIT_TIME = 5000;
    private TaskService client;
    private WorkItemHandler handler;
    protected TestStatefulKnowledgeSession ksession = new TestStatefulKnowledgeSession();

    public void setClient(TaskService client) {
        this.client = client;
    }

    public TaskService getClient() {
        return this.client;
    }

    public void testTask() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((long)10L, (long)task.getProcessInstanceId());
        this.client.start(task.getId(), "Darth Vader");
        this.client.complete(task.getId(), "Darth Vader", null);
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void testTaskMultipleActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader, Dalai Lama");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        this.getClient().claim(task.getId(), "Darth Vader");
        this.getClient().start(task.getId(), "Darth Vader");
        this.getClient().complete(task.getId(), "Darth Vader", null);
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void testTaskGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner(null, groupIds, "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Ready, (Object)taskSummary.getStatus());
        PermissionDeniedException denied = null;
        try {
            this.getClient().claim(taskSummary.getId(), "Darth Vader");
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        WSHumanTaskHandlerBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task = this.getClient().getTask(taskSummary.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
    }

    public void testTaskSingleAndGroupActors() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task One");
        workItem.setParameter("TaskName", (Object)"TaskNameOne");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("GroupId", (Object)"Crusaders");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task Two");
        workItem.setParameter("TaskName", (Object)"TaskNameTwo");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Crusaders");
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", groupIds, "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testTaskFail() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        this.getClient().start(task.getId(), "Darth Vader");
        this.getClient().fail(task.getId(), "Darth Vader", null);
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    public void testTaskSkip() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        this.getClient().skip(task.getId(), "Darth Vader");
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillAborted(5000L));
    }

    public void testTaskExit() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Task task = this.getClient().getTaskByWorkItemId(workItem.getId());
        this.getClient().exit(task.getId().longValue(), "Administrator");
        task = this.getClient().getTaskByWorkItemId(workItem.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)((I18NText)task.getNames().get(0)).getText());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)((I18NText)task.getDescriptions().get(0)).getText());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskExitNonAdministrator() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Task task = this.getClient().getTaskByWorkItemId(workItem.getId());
        try {
            this.getClient().exit(task.getId().longValue(), "Darth Vader");
            WSHumanTaskHandlerBaseSyncTest.fail((String)"Should not allow to exit task for non administrators");
        }
        catch (PermissionDeniedException e) {
            // empty catch block
        }
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
    }

    public void testTaskAbortSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskAbortNotSkippable() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Skippable", (Object)"false");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        this.getHandler().abortWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)0, (int)tasks.size());
    }

    public void testTaskData() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("Content", (Object)"This is the content");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        Task task = this.getClient().getTask(taskSummary.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)task.getTaskData().getProcessSessionId(), (int)TestStatefulKnowledgeSession.testSessionId);
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerBaseSyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getClient().getContent(contentId).getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Object data = in.readObject();
        in.close();
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)"This is the content", (Object)data);
        this.getClient().start(task.getId().longValue(), "Darth Vader");
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.getClient().complete(task.getId().longValue(), "Darth Vader", result);
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerBaseSyncTest.assertNotNull(results);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void testTaskDataAutomaticMapping() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        MyObject myObject = new MyObject("MyObjectValue");
        workItem.setParameter("MyObject", (Object)myObject);
        HashMap<String, MyObject> mapParameter = new HashMap<String, MyObject>();
        mapParameter.put("MyObjectInsideTheMap", myObject);
        workItem.setParameter("MyMap", mapParameter);
        workItem.setParameter("MyObject", (Object)myObject);
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskName", (String)taskSummary.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)taskSummary.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Comment", (String)taskSummary.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)taskSummary.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)taskSummary.getActualOwner().getId());
        Task task = this.getClient().getTask(taskSummary.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task.getTaskData().getDocumentAccessType());
        long contentId = task.getTaskData().getDocumentContentId();
        WSHumanTaskHandlerBaseSyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getClient().getContent(contentId).getContent());
        ObjectInputStream in = new ObjectInputStream(bis);
        Map data = (Map)in.readObject();
        in.close();
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"MyObjectValue", (String)((MyObject)data.get("MyObject")).getValue());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)"10", data.get("Priority"));
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"MyObjectValue", (String)((MyObject)((Map)data.get("MyMap")).get("MyObjectInsideTheMap")).getValue());
        this.getClient().start(task.getId().longValue(), "Darth Vader");
        ContentData result = new ContentData();
        result.setAccessType(AccessType.Inline);
        result.setType("java.lang.String");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject("This is the result");
        out.close();
        result.setContent(bos.toByteArray());
        this.getClient().complete(task.getId().longValue(), "Darth Vader", result);
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
        Map<String, Object> results = manager.getResults();
        WSHumanTaskHandlerBaseSyncTest.assertNotNull(results);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)"Darth Vader", (Object)results.get("ActorId"));
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)"This is the result", (Object)results.get("Result"));
    }

    public void testTaskCreateFailedWithLog() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        if (this.handler instanceof SyncWSHumanTaskHandler) {
            ((SyncWSHumanTaskHandler)this.handler).setAction(OnErrorAction.LOG);
        }
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"DoesNotExist");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        WSHumanTaskHandlerBaseSyncTest.assertFalse((boolean)manager.isAborted());
    }

    public void testTaskCreateFailedWithAbort() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        if (this.handler instanceof SyncWSHumanTaskHandler) {
            ((SyncWSHumanTaskHandler)this.handler).setAction(OnErrorAction.ABORT);
        }
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"DoesNotExist");
        workItem.setProcessInstanceId(10L);
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.isAborted());
    }

    public void testTaskCreateFailedWithRethrow() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        if (this.handler instanceof SyncWSHumanTaskHandler) {
            ((SyncWSHumanTaskHandler)this.handler).setAction(OnErrorAction.RETHROW);
        }
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"DoesNotExist");
        workItem.setProcessInstanceId(10L);
        try {
            this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            WSHumanTaskHandlerBaseSyncTest.fail((String)"Should fail due to OnErroAction set to rethrow");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void TODOtestOnAllSubTasksEndParentEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnAllSubTasksEndParentEnd");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        this.getClient().start(task.getId(), "Darth Vader");
        Task parentTask = this.getClient().getTask(task.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        List subTasks = this.getClient().getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerBaseSyncTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerBaseSyncTest.assertNotNull((Object)subTaskSummary2);
        this.getClient().start(subTaskSummary1.getId(), "Darth Vader");
        this.getClient().start(subTaskSummary2.getId(), "Darth Vader");
        Task subTask1 = this.getClient().getTask(subTaskSummary1.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        Task subTask2 = this.getClient().getTask(subTaskSummary2.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        this.getClient().complete(subTask1.getId().longValue(), "Darth Vader", null);
        this.getClient().complete(subTask2.getId().longValue(), "Darth Vader", null);
        subTask1 = this.getClient().getTask(subTask1.getId().longValue());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        subTask2 = this.getClient().getTask(subTask2.getId().longValue());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        parentTask = this.getClient().getTask(parentTask.getId().longValue());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Completed, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void TODOtestOnParentAbortAllSubTasksEndStrategy() throws Exception {
        TestWorkItemManager manager = new TestWorkItemManager();
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameParent");
        workItem.setParameter("Comment", (Object)"CommentParent");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("SubTaskStrategies", (Object)"OnParentAbortAllSubTasksEnd");
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        List tasks = this.getClient().getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"TaskNameParent", (String)task.getName());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"CommentParent", (String)task.getDescription());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskNameChild1");
        workItem.setParameter("Comment", (Object)"CommentChild1");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        workItem = new WorkItemImpl();
        workItem.setName("Human Task2");
        workItem.setParameter("TaskName", (Object)"TaskNameChild2");
        workItem.setParameter("Comment", (Object)"CommentChild2");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setParameter("ParentId", (Object)task.getId());
        this.getHandler().executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        this.getClient().start(task.getId(), "Darth Vader");
        Task parentTask = this.getClient().getTask(task.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)parentTask.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)parentTask.getTaskData().getActualOwner());
        List subTasks = this.getClient().getSubTasksAssignedAsPotentialOwner(parentTask.getId().longValue(), "Darth Vader", "en-UK");
        WSHumanTaskHandlerBaseSyncTest.assertEquals((int)2, (int)subTasks.size());
        TaskSummary subTaskSummary1 = (TaskSummary)subTasks.get(0);
        TaskSummary subTaskSummary2 = (TaskSummary)subTasks.get(1);
        WSHumanTaskHandlerBaseSyncTest.assertNotNull((Object)subTaskSummary1);
        WSHumanTaskHandlerBaseSyncTest.assertNotNull((Object)subTaskSummary2);
        this.getClient().start(subTaskSummary1.getId(), "Darth Vader");
        this.getClient().start(subTaskSummary2.getId(), "Darth Vader");
        Task subTask1 = this.getClient().getTask(subTaskSummary1.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        Task subTask2 = this.getClient().getTask(subTaskSummary2.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        this.getClient().skip(parentTask.getId().longValue(), "Darth Vader");
        subTask1 = this.getClient().getTask(subTaskSummary1.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Completed, (Object)subTask1.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask1.getTaskData().getActualOwner());
        subTask2 = this.getClient().getTask(subTaskSummary2.getId());
        WSHumanTaskHandlerBaseSyncTest.assertEquals((Object)Status.Completed, (Object)subTask2.getTaskData().getStatus());
        WSHumanTaskHandlerBaseSyncTest.assertEquals(this.users.get("darth"), (Object)subTask2.getTaskData().getActualOwner());
        WSHumanTaskHandlerBaseSyncTest.assertTrue((boolean)manager.waitTillCompleted(5000L));
    }

    public void setHandler(WorkItemHandler handler) {
        this.handler = handler;
    }

    public WorkItemHandler getHandler() {
        return this.handler;
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile Map<String, Object> results;

        private TestWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

