/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.Group;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.MockEscalatedDeadlineHandler;
import org.jbpm.task.service.SendIcal;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.UserGroupCallbackManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTest
extends TestCase {
    protected static Logger logger = LoggerFactory.getLogger(BaseTest.class);
    protected EntityManagerFactory emf;
    protected Map<String, User> users;
    protected Map<String, Group> groups;
    protected TaskService taskService;
    protected TaskServiceSession taskSession;
    protected boolean useJTA = false;
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private PoolingDataSource pds;

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)"org.jbpm.task");
    }

    protected void setUp() throws Exception {
        Properties conf = new Properties();
        conf.setProperty("mail.smtp.host", "localhost");
        conf.setProperty("mail.smtp.port", "2345");
        conf.setProperty("from", "from@domain.com");
        conf.setProperty("replyTo", "replyTo@domain.com");
        conf.setProperty("defaultLanguage", "en-UK");
        SendIcal.initInstance((Properties)conf);
        Properties dsProps = this.loadDataSourceProperties();
        String txType = dsProps.getProperty("txType", "RESOURCE_LOCAL");
        if ("RESOURCE_LOCAL".equals(txType)) {
            this.useJTA = false;
        } else if ("JTA".equals(txType)) {
            this.useJTA = true;
        }
        if (this.useJTA) {
            this.pds = new PoolingDataSource();
            this.pds.setUniqueName("jdbc/taskDS");
            this.pds.setClassName(dsProps.getProperty("className"));
            this.pds.setMaxPoolSize(Integer.parseInt(dsProps.getProperty("maxPoolSize")));
            this.pds.setAllowLocalTransactions(Boolean.parseBoolean(dsProps.getProperty("allowLocalTransactions")));
            for (String propertyName : new String[]{"user", "password"}) {
                this.pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            this.setDatabaseSpecificDataSourceProperties(this.pds, dsProps);
            this.pds.init();
        }
        this.emf = this.createEntityManagerFactory();
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        MockUserInfo userInfo = new MockUserInfo();
        this.taskService.setUserinfo((UserInfo)userInfo);
        this.users = BaseTest.fillUsersOrGroups("LoadUsers.mvel");
        this.groups = BaseTest.fillUsersOrGroups("LoadGroups.mvel");
        this.taskService.addUsersAndGroups(this.users, this.groups);
        this.disableUserGroupCallback();
        logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.taskSession = this.taskService.createSession();
    }

    protected Properties loadDataSourceProperties() {
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        InputStream propsInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(DATASOURCE_PROPERTIES);
        BaseTest.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
        Properties dsProps = new Properties();
        if (propsInputStream != null) {
            try {
                dsProps.load(propsInputStream);
            }
            catch (IOException ioe) {
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        return dsProps;
    }

    protected void tearDown() throws Exception {
        if (this.taskSession != null) {
            this.taskSession.dispose();
        }
        this.emf.close();
        if (this.useJTA) {
            this.pds.close();
        }
    }

    public void disableUserGroupCallback() {
        UserGroupCallbackManager.getInstance().setCallback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map fillUsersOrGroups(String mvelFileName) throws Exception {
        HashMap vars = new HashMap();
        Reader reader = null;
        Map result = null;
        try {
            reader = new InputStreamReader(BaseTest.class.getResourceAsStream(mvelFileName));
            result = (Map)BaseTest.eval(reader, vars);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return result;
    }

    public static void loadUsersAndGroups(TaskServiceSession taskSession, Map<String, User> users, Map<String, Group> groups) throws Exception {
        for (User user : users.values()) {
            taskSession.addUser(user);
        }
        for (Group group : groups.values()) {
            taskSession.addGroup(group);
        }
    }

    public static Object eval(Reader reader, Map vars) {
        vars.put("now", new Date());
        return TaskService.eval((Reader)reader, (Map)vars);
    }

    public Object eval(String str, Map vars) {
        vars.put("now", new Date());
        return TaskService.eval((String)str, (Map)vars);
    }

    protected Map<String, Object> fillVariables() {
        return BaseTest.fillVariables(this.users, this.groups);
    }

    public static Map<String, Object> fillVariables(Map<String, User> users, Map<String, Group> groups) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("users", users);
        vars.put("groups", groups);
        vars.put("now", new Date());
        return vars;
    }

    protected static void testDeadlines(long now, MockEscalatedDeadlineHandler handler) throws Exception {
        int sleep = 8000;
        handler.wait(3, sleep);
        BaseTest.assertEquals((int)3, (int)handler.getList().size());
        boolean firstDeadlineMet = false;
        boolean secondDeadlineMet = false;
        boolean thirdDeadlineMet = false;
        for (MockEscalatedDeadlineHandler.Item item : handler.getList()) {
            long deadlineTime = item.getDeadline().getDate().getTime();
            if (deadlineTime == now + 2000L) {
                firstDeadlineMet = true;
                continue;
            }
            if (deadlineTime == now + 4000L) {
                secondDeadlineMet = true;
                continue;
            }
            if (deadlineTime == now + 6000L) {
                thirdDeadlineMet = true;
                continue;
            }
            BaseTest.fail((String)(deadlineTime + " is not an expected deadline time. Now is [" + now + " (" + (deadlineTime - now) + ")]."));
        }
        BaseTest.assertTrue((String)"First deadline was not met.", (boolean)firstDeadlineMet);
        BaseTest.assertTrue((String)"Second deadline was not met.", (boolean)secondDeadlineMet);
        BaseTest.assertTrue((String)"Third deadline was not met.", (boolean)thirdDeadlineMet);
        Thread.sleep(1000L);
    }

    private void setDatabaseSpecificDataSourceProperties(PoolingDataSource pds, Properties dsProps) {
        String driverClass = dsProps.getProperty("driverClassName");
        if (driverClass.startsWith("org.h2")) {
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else if (driverClass.startsWith("oracle")) {
            pds.getDriverProperties().put("driverType", "thin");
            pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
        } else if (driverClass.startsWith("com.ibm.db2")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            pds.getDriverProperties().put("driverType", "4");
        } else if (driverClass.startsWith("com.microsoft")) {
            for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
            pds.getDriverProperties().put("selectMethod", "cursor");
            pds.getDriverProperties().put("InstanceName", "MSSQL01");
        } else if (driverClass.startsWith("com.mysql")) {
            for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else if (driverClass.startsWith("com.sybase")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
            pds.getDriverProperties().put("REQUEST_HA_SESSION", "false");
            pds.getDriverProperties().put("networkProtocol", "Tds");
        } else if (driverClass.startsWith("org.postgresql")) {
            for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else {
            throw new RuntimeException("Unknown driver class: " + driverClass);
        }
    }
}

