/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.AllowedToDelegate;
import org.jbpm.task.Attachment;
import org.jbpm.task.BaseTest;
import org.jbpm.task.BooleanExpression;
import org.jbpm.task.Comment;
import org.jbpm.task.Deadline;
import org.jbpm.task.Deadlines;
import org.jbpm.task.Delegation;
import org.jbpm.task.Escalation;
import org.jbpm.task.I18NText;
import org.jbpm.task.Notification;
import org.jbpm.task.PeopleAssignments;
import org.jbpm.task.Reassignment;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.service.TaskServiceSession;

public class ModelPersistenceTest
extends BaseTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testfullHibernateRoundtripWithAdditionalMVELCheck() throws Exception {
        Task task1 = new Task();
        task1.setPriority(100);
        PeopleAssignments peopleAssignments = new PeopleAssignments();
        task1.setPeopleAssignments(peopleAssignments);
        peopleAssignments.setTaskInitiator((User)this.users.get("darth"));
        ArrayList potentialOwners = new ArrayList();
        peopleAssignments.setPotentialOwners(potentialOwners);
        potentialOwners.add(this.users.get("bobba"));
        potentialOwners.add(this.users.get("jabba"));
        ArrayList excludedOwners = new ArrayList();
        peopleAssignments.setExcludedOwners(excludedOwners);
        excludedOwners.add(this.users.get("dalai"));
        excludedOwners.add(this.users.get("christoper"));
        ArrayList stakeholders = new ArrayList();
        peopleAssignments.setTaskStakeholders(stakeholders);
        stakeholders.add(this.users.get("stuart"));
        stakeholders.add(this.users.get("jane"));
        ArrayList businessAdmin = new ArrayList();
        peopleAssignments.setBusinessAdministrators(businessAdmin);
        businessAdmin.add(this.users.get("peter"));
        businessAdmin.add(this.users.get("steve"));
        ArrayList recipients = new ArrayList();
        peopleAssignments.setRecipients(recipients);
        recipients.add(this.users.get("sly"));
        recipients.add(this.users.get("liz"));
        TaskData taskData = new TaskData();
        task1.setTaskData(taskData);
        taskData.setActualOwner((User)this.users.get("liz"));
        taskData.setCreatedBy((User)this.users.get("sly"));
        taskData.setActivationTime(new Date(10000000L));
        taskData.setCreatedOn(new Date(10000000L));
        taskData.setExpirationTime(new Date(10000000L));
        taskData.setStatus(Status.Created);
        taskData.setDocumentAccessType(AccessType.Inline);
        taskData.setDocumentType("mvel");
        taskData.setDocumentContentId(20L);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        taskData.setAttachments(attachments);
        Attachment attachment = new Attachment();
        attachment.setAccessType(AccessType.Inline);
        attachment.setAttachedAt(new Date(10000000L));
        attachment.setAttachedBy((User)this.users.get("liz"));
        attachment.setContentType("text");
        attachment.setName("file.txt");
        attachment.setSize(5000);
        attachment.setAttachmentContentId(5L);
        attachments.add(attachment);
        attachment = new Attachment();
        attachment.setAccessType(AccessType.Url);
        attachment.setAttachedAt(new Date(10000000L));
        attachment.setAttachedBy((User)this.users.get("liz"));
        attachment.setContentType("text");
        attachment.setName("file2.txt");
        attachment.setSize(500);
        attachment.setAttachmentContentId(3L);
        attachments.add(attachment);
        ArrayList<Comment> comments = new ArrayList<Comment>();
        taskData.setComments(comments);
        Comment comment = new Comment();
        comment.setAddedBy((User)this.users.get("peter"));
        comment.setAddedAt(new Date(10000000L));
        comment.setText("this is a short comment");
        comments.add(comment);
        comment = new Comment();
        comment.setAddedBy((User)this.users.get("steve"));
        comment.setAddedAt(new Date(10000000L));
        comment.setText("this is a loooooooooooooooooooooooooooooooooooooooooooooooong comment");
        comments.add(comment);
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        task1.setNames(names);
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        task1.setSubjects(subjects);
        ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
        task1.setDescriptions(descriptions);
        names.add(new I18NText("en-UK", "This is my task name"));
        names.add(new I18NText("en-DK", "Dies ist mein task Name"));
        subjects.add(new I18NText("en-UK", "This is my task subject"));
        subjects.add(new I18NText("en-DK", "Das ist mein task Thema"));
        descriptions.add(new I18NText("en-UK", "This is my task description"));
        descriptions.add(new I18NText("en-DK", "Das ist mein task Beschreibung"));
        Delegation delegation = new Delegation();
        task1.setDelegation(delegation);
        delegation.setAllowed(AllowedToDelegate.PotentialOwners);
        ArrayList delegates = new ArrayList();
        delegation.setDelegates(delegates);
        delegates.add(this.groups.get("crusaders"));
        delegates.add(this.groups.get("knightsTempler"));
        Deadlines deadlines = new Deadlines();
        task1.setDeadlines(deadlines);
        ArrayList<Deadline> startDeadlines = new ArrayList<Deadline>();
        deadlines.setStartDeadlines(startDeadlines);
        Deadline deadline = new Deadline();
        deadline.setEscalated(Boolean.valueOf(true));
        startDeadlines.add(deadline);
        deadline.setDate(new Date(10000000L));
        ArrayList<I18NText> docs = new ArrayList<I18NText>();
        deadline.setDocumentation(docs);
        docs.add(new I18NText("en-UK", "Start Deadline documentation"));
        docs.add(new I18NText("en-DK", "Start Termin Dokumentation"));
        ArrayList<Escalation> escalations = new ArrayList<Escalation>();
        deadline.setEscalations(escalations);
        Escalation escalation = new Escalation();
        escalations.add(escalation);
        escalation.setName("My Start Escalation");
        ArrayList<BooleanExpression> constraints = new ArrayList<BooleanExpression>();
        escalation.setConstraints(constraints);
        constraints.add(new BooleanExpression("mvel", "true"));
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        escalation.setNotifications(notifications);
        Notification notification = new Notification();
        notifications.add(notification);
        notification.setPriority(1000);
        docs = new ArrayList();
        notification.setDocumentation(docs);
        docs.add(new I18NText("en-UK", "Start Notification documentation"));
        docs.add(new I18NText("en-DK", "Start Anmeldung Dokumentation"));
        businessAdmin = new ArrayList();
        notification.setBusinessAdministrators(businessAdmin);
        businessAdmin.add(this.users.get("bruce"));
        businessAdmin.add(this.users.get("peter"));
        recipients = new ArrayList();
        notification.setRecipients(recipients);
        recipients.add(this.users.get("tony"));
        recipients.add(this.users.get("darth"));
        names = new ArrayList();
        notification.setNames(names);
        subjects = new ArrayList();
        notification.setSubjects(subjects);
        descriptions = new ArrayList();
        notification.setDescriptions(descriptions);
        names.add(new I18NText("en-UK", "This is my start notification name"));
        names.add(new I18NText("en-DK", "Dies ist mein start anmeldung Name"));
        subjects.add(new I18NText("en-UK", "This is my start notification subject"));
        subjects.add(new I18NText("en-DK", "Das ist mein start anmeldung Thema"));
        descriptions.add(new I18NText("en-UK", "This is my start notification description"));
        descriptions.add(new I18NText("en-DK", "Das ist mein start anmeldung Beschreibung"));
        ArrayList<Reassignment> reassignments = new ArrayList<Reassignment>();
        escalation.setReassignments(reassignments);
        Reassignment reassignment = new Reassignment();
        reassignments.add(reassignment);
        docs = new ArrayList();
        reassignment.setDocumentation(docs);
        docs.add(new I18NText("en-UK", "Start Reassignment documentation"));
        docs.add(new I18NText("en-DK", "Start Neuzuweisung Dokumentation"));
        potentialOwners = new ArrayList();
        reassignment.setPotentialOwners(potentialOwners);
        potentialOwners.add(this.users.get("bobba"));
        potentialOwners.add(this.users.get("luke"));
        ArrayList<Deadline> endDeadlines = new ArrayList<Deadline>();
        deadlines.setEndDeadlines(endDeadlines);
        deadline = new Deadline();
        deadline.setEscalated(Boolean.valueOf(true));
        endDeadlines.add(deadline);
        deadline.setDate(new Date(10000000L));
        docs = new ArrayList();
        deadline.setDocumentation(docs);
        docs.add(new I18NText("en-UK", "End Deadline documentation"));
        docs.add(new I18NText("en-DK", "Ende Termin Dokumentation"));
        escalations = new ArrayList();
        deadline.setEscalations(escalations);
        escalation = new Escalation();
        escalations.add(escalation);
        escalation.setName("My End Escalation");
        constraints = new ArrayList();
        escalation.setConstraints(constraints);
        constraints.add(new BooleanExpression("mvel", "true"));
        notifications = new ArrayList();
        escalation.setNotifications(notifications);
        notification = new Notification();
        notifications.add(notification);
        notification.setPriority(1000);
        docs = new ArrayList();
        notification.setDocumentation(docs);
        docs.add(new I18NText("en-UK", "End Notification documentation"));
        docs.add(new I18NText("en-DK", "Ende Anmeldung Dokumentation"));
        businessAdmin = new ArrayList();
        notification.setBusinessAdministrators(businessAdmin);
        businessAdmin.add(this.users.get("bobba"));
        businessAdmin.add(this.users.get("darth"));
        recipients = new ArrayList();
        notification.setRecipients(recipients);
        recipients.add(this.users.get("liz"));
        recipients.add(this.users.get("jane"));
        names = new ArrayList();
        notification.setNames(names);
        subjects = new ArrayList();
        notification.setSubjects(subjects);
        descriptions = new ArrayList();
        notification.setDescriptions(descriptions);
        names.add(new I18NText("en-UK", "This is my end notification name"));
        names.add(new I18NText("en-DK", "Dies ist mein ende anmeldung Name"));
        subjects.add(new I18NText("en-UK", "This is my end notification subject"));
        subjects.add(new I18NText("en-DK", "Das ist mein ende anmeldung Thema"));
        descriptions.add(new I18NText("en-UK", "This is my end notification description"));
        descriptions.add(new I18NText("en-DK", "Das ist mein ende anmeldung Beschreibung"));
        reassignments = new ArrayList();
        escalation.setReassignments(reassignments);
        reassignment = new Reassignment();
        reassignments.add(reassignment);
        docs = new ArrayList();
        reassignment.setDocumentation(docs);
        docs.add(new I18NText("en-UK", "End Reassignment documentation"));
        docs.add(new I18NText("en-DK", "Ende Neuzuweisung Dokumentation"));
        potentialOwners = new ArrayList();
        reassignment.setPotentialOwners(potentialOwners);
        potentialOwners.add(this.users.get("stuart"));
        potentialOwners.add(this.users.get("dalai"));
        TaskServiceSession session = this.taskService.createSession();
        session.addTask(task1, null);
        session.dispose();
        session = this.taskService.createSession();
        Task task2 = session.getTask(task1.getId().longValue());
        ModelPersistenceTest.assertNotSame((Object)task1, (Object)task2);
        ModelPersistenceTest.assertEquals((Object)task1, (Object)task2);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("FullyPopulatedTask.mvel"));
        Map<String, Object> vars = this.fillVariables();
        vars.put("bytes1", new byte[]{1, 0, 0, 1});
        Task task3 = (Task)ModelPersistenceTest.eval(reader, vars);
        ModelPersistenceTest.assertNotSame((Object)task1, (Object)task3);
        ModelPersistenceTest.assertEquals((Object)task1, (Object)task3);
        session.dispose();
    }
}

