/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jbpm.task.BaseTest;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class IcalBaseTest
extends BaseTest {
    protected TaskServer server;
    protected TaskClient client;
    private Wiser wiser;
    private String emailHost;
    private String emailPort;

    public void testSendWithStartandEndDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')],";
        str = str + "deadlines = (with (new Deadlines() ) {";
        str = str + "    startDeadlines = [ ";
        str = str + "       (with (new Deadline()) {";
        str = str + "           date = now";
        str = str + "       } ) ],";
        str = str + "    endDeadlines = [";
        str = str + "        (with (new Deadline()) {";
        str = str + "             date = new Date( now.time + ( 1000 * 60 * 60 * 24 ) )";
        str = str + "        } ) ]";
        str = str + "} ) })";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)IcalBaseTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId(20000);
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(10000L);
        IcalBaseTest.assertEquals((int)2, (int)this.getWiser().getMessages().size());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.getWiser().getMessages().get(1)).getEnvelopeReceiver());
        String subject = "Summary\n-------\n\nThis is my task subject\n\n";
        String description = "Description\n-----------\n\nThis is my task description";
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        IcalBaseTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalBaseTest.assertEquals((String)"Task Assignment Start Event: This is my task name", (String)msg.getSubject());
        MimeMultipart multiPart = (MimeMultipart)msg.getContent();
        BodyPart messageBodyPart = multiPart.getBodyPart(0);
        IcalBaseTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        String content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalBaseTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-Start-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalBaseTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task Start : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
        msg = ((WiserMessage)this.getWiser().getMessages().get(1)).getMimeMessage();
        IcalBaseTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalBaseTest.assertEquals((String)"Task Assignment End Event: This is my task name", (String)msg.getSubject());
        multiPart = (MimeMultipart)msg.getContent();
        messageBodyPart = multiPart.getBodyPart(0);
        IcalBaseTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalBaseTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-End-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalBaseTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task End : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
    }

    public void testSendWithStartDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')],";
        str = str + "deadlines = (with (new Deadlines() ) {";
        str = str + "    startDeadlines = [ ";
        str = str + "       (with (new Deadline()) {";
        str = str + "           date = now";
        str = str + "       } ) ]";
        str = str + "} ) })";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)IcalBaseTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId(20000);
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(10000L);
        IcalBaseTest.assertEquals((int)1, (int)this.getWiser().getMessages().size());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        String subject = "Summary\n-------\n\nThis is my task subject\n\n";
        String description = "Description\n-----------\n\nThis is my task description";
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        IcalBaseTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalBaseTest.assertEquals((String)"Task Assignment Start Event: This is my task name", (String)msg.getSubject());
        MimeMultipart multiPart = (MimeMultipart)msg.getContent();
        BodyPart messageBodyPart = multiPart.getBodyPart(0);
        IcalBaseTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        String content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalBaseTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-Start-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalBaseTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task Start : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
    }

    public void testSendWithEndDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')],";
        str = str + "deadlines = (with (new Deadlines() ) {";
        str = str + "    endDeadlines = [";
        str = str + "        (with (new Deadline()) {";
        str = str + "             date = new Date( now.time + ( 1000 * 60 * 60 * 24 ) )";
        str = str + "        } ) ]";
        str = str + "} ) })";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)IcalBaseTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId(20000);
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        IcalBaseTest.assertEquals((int)1, (int)this.getWiser().getMessages().size());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        String subject = "Summary\n-------\n\nThis is my task subject\n\n";
        String description = "Description\n-----------\n\nThis is my task description";
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        IcalBaseTest.assertEqualsIgnoreWhitespace("multipart/alternative;boundary=\"----=_Part_", msg.getContentType(), 0, 47);
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        IcalBaseTest.assertEquals((String)"steve@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        IcalBaseTest.assertEquals((String)"Task Assignment End Event: This is my task name", (String)msg.getSubject());
        MimeMultipart multiPart = (MimeMultipart)msg.getContent();
        BodyPart messageBodyPart = multiPart.getBodyPart(0);
        IcalBaseTest.assertEquals((String)"text/plain; charset=UTF8;", (String)messageBodyPart.getDataHandler().getContentType());
        String content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace(subject + description, content);
        messageBodyPart = multiPart.getBodyPart(1);
        IcalBaseTest.assertEquals((String)"text/calendar; charset=UTF8; name=ical-End-1.ics", (String)messageBodyPart.getDataHandler().getContentType());
        content = new String(IcalBaseTest.getBytes(messageBodyPart.getDataHandler().getInputStream()));
        IcalBaseTest.assertEqualsIgnoreWhitespace("BEGIN:VCALENDARPRODID:-//iCal4j 1.0//ENCALSCALE:GREGORIANVERSION:2.0METHOD:REQUESTBEGIN:VEVENTDTSTART;TZID=UTC:", content.substring(0, 123));
        IcalBaseTest.assertEqualsIgnoreWhitespace("SUMMARY:\"Task End : This is my task subject\"DESCRIPTION:\"This is my task description\"PRIORITY:55END:VEVENTEND:VCALENDAR", content.substring(content.length() - 131, content.length()));
    }

    public void testSendWithNoDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { createdOn = now, createdBy = users['tony'], activationTime = now}), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) {potentialOwners = [users['steve' ], users['tony' ]]}), ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')],";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my task subject')],";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my task description')]";
        str = str + "})";
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("steve"), "steve@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("steve"), "en-UK");
        this.taskService.setUserinfo((UserInfo)userInfo);
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)IcalBaseTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId(20000);
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("steve")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        IcalBaseTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        IcalBaseTest.assertEqualsIgnoreWhitespace(expected, actual, 0, actual.length());
    }

    private static void assertEqualsIgnoreWhitespace(String expected, String actual, int beginIndex, int endIndex) {
        String cleanExpected = expected.replaceAll("\\s+", "").replaceAll("\\n", "").replaceAll("\\r", "");
        String cleanActual = actual.substring(beginIndex, endIndex).replaceAll("\\s+", "").replaceAll("\\n", "").replaceAll("\\r", "");
        IcalBaseTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    private static byte[] getBytes(InputStream inputStream) throws Exception {
        int readBytes;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        byte[] bytes = new byte[512];
        while ((readBytes = inputStream.read(bytes)) > 0) {
            outputStream.write(bytes, 0, readBytes);
        }
        byte[] byteData = outputStream.toByteArray();
        inputStream.close();
        outputStream.close();
        return byteData;
    }

    public void setWiser(Wiser wiser) {
        this.wiser = wiser;
    }

    public Wiser getWiser() {
        return this.wiser;
    }

    public void setEmailHost(String emailHost) {
        this.emailHost = emailHost;
    }

    public String getEmailHost() {
        return this.emailHost;
    }

    public void setEmailPort(String emailPort) {
        this.emailPort = emailPort;
    }

    public String getEmailPort() {
        return this.emailPort;
    }
}

