/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.List;
import java.util.Properties;
import org.jbpm.task.service.LDAPUserGroupCallbackImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class LDAPUserGroupCallbackImplTest {
    @Test
    public void testUserExists() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=my-domain,dc=com");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=my-domain,dc=com");
        properties.setProperty("ldap.user.roles.ctx", "ou=Roles,dc=my-domain,dc=com");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.user.roles.filter", "(member={0})");
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl(properties);
        boolean userExists = ldapUserGroupCallback.existsUser("john");
        Assert.assertTrue((boolean)userExists);
    }

    @Test
    public void testGroupExists() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=my-domain,dc=com");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=my-domain,dc=com");
        properties.setProperty("ldap.user.roles.ctx", "ou=Roles,dc=my-domain,dc=com");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.user.roles.filter", "(member={0})");
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl(properties);
        boolean userExists = ldapUserGroupCallback.existsGroup("Echo");
        Assert.assertTrue((boolean)userExists);
    }

    @Test
    public void testUserGroup() {
        Properties properties = new Properties();
        properties.setProperty("ldap.user.ctx", "ou=People,dc=my-domain,dc=com");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=my-domain,dc=com");
        properties.setProperty("ldap.user.roles.ctx", "ou=Roles,dc=my-domain,dc=com");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.user.roles.filter", "(member={0})");
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl(properties);
        List userGroups = ldapUserGroupCallback.getGroupsForUser("john", null, null);
        Assert.assertEquals((long)1L, (long)userGroups.size());
    }

    @Test
    public void testDefaultPropsUserExists() {
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl();
        boolean userExists = ldapUserGroupCallback.existsUser("john");
        Assert.assertTrue((boolean)userExists);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidationErrorUserExists() {
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl(new Properties());
        boolean userExists = ldapUserGroupCallback.existsUser("john");
        Assert.assertTrue((boolean)userExists);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidationErrorGroupExists() {
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl(new Properties());
        boolean userExists = ldapUserGroupCallback.existsGroup("john");
        Assert.assertTrue((boolean)userExists);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidationErrorUserGroup() {
        Properties properties = new Properties();
        LDAPUserGroupCallbackImpl ldapUserGroupCallback = new LDAPUserGroupCallbackImpl(properties);
        List userGroups = ldapUserGroupCallback.getGroupsForUser("john", null, null);
        Assert.assertEquals((long)1L, (long)userGroups.size());
    }
}

