/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Group;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.utils.CollectionUtils;

public abstract class TaskServiceBaseTest
extends BaseTest {
    protected TaskServer server;
    protected TaskClient client;

    public void testTasksOwnedQueryWithI18N() throws Exception {
        TaskServiceBaseTest.runTestTasksOwnedQueryWithI18N(this.client, this.users, this.groups);
    }

    public static void runTestTasksOwnedQueryWithI18N(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceBaseTest.fillVariables(users, groups);
        BlockingAllOpenTasksForUseResponseHandler getTaskshandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("peter").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTaskshandler);
        int peterSize = getTaskshandler.getResults().size();
        getTaskshandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("steve").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTaskshandler);
        int steveSize = getTaskshandler.getResults().size();
        getTaskshandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("darth").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTaskshandler);
        int darthSize = getTaskshandler.getResults().size();
        InputStreamReader reader = new InputStreamReader(TaskServiceBaseTest.class.getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)responseHandler);
        }
        reader = new InputStreamReader(TaskServiceBaseTest.class.getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInEnglish.mvel"));
        Map expected = (Map)TaskServiceBaseTest.eval(reader, vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("peter").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(peterSize + 3), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual.subList(0, ((List)expected.get("peter")).size())));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("steve").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(steveSize + 2), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual.subList(0, ((List)expected.get("steve")).size())));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("darth").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(darthSize + 1), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual.subList(0, ((List)expected.get("darth")).size())));
        reader = new InputStreamReader(TaskServiceBaseTest.class.getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInGerman.mvel"));
        expected = (Map)TaskServiceBaseTest.eval(reader, vars);
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("peter").getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(peterSize + 3), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual.subList(0, ((List)expected.get("peter")).size())));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("steve").getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(steveSize + 2), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual.subList(0, ((List)expected.get("steve")).size())));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("darth").getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(darthSize + 1), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual.subList(0, ((List)expected.get("darth")).size())));
    }

    public void testPotentialOwnerQueries() {
        TaskServiceBaseTest.runTestPotentialOwnerQueries(this.client, this.users, this.groups);
    }

    public static void runTestPotentialOwnerQueries(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceBaseTest.fillVariables(users, groups);
        BlockingAllOpenTasksForUseResponseHandler getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        List<TaskSummary> actual = getTasksHandler.getResults();
        int originalSize = actual.size();
        InputStreamReader reader = new InputStreamReader(TaskServiceBaseTest.class.getResourceAsStream("/org/jbpm/task/service/QueryData_TasksPotentialOwner.mvel"));
        List tasks = (List)TaskServiceBaseTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskHandler = new BlockingAddTaskResponseHandler();
            client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskHandler);
        }
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        actual = getTasksHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(originalSize + 2), (int)actual.size());
    }

    public void testPeopleAssignmentQueries() {
        TaskServiceBaseTest.runTestPeopleAssignmentQueries(this.client, this.taskSession, this.users, this.groups);
    }

    public static void runTestPeopleAssignmentQueries(TaskClient client, TaskServiceSession taskSession, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceBaseTest.fillVariables(users, groups);
        BlockingAllOpenTasksForUseResponseHandler getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsTaskInitiator(users.get("darth").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        int darthSize = getTasksHandler.getResults().size();
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsExcludedOwner(users.get("liz").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        int lizSize = getTasksHandler.getResults().size();
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        int bobbaSize = getTasksHandler.getResults().size();
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsRecipient(users.get("sly").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        int slySize = getTasksHandler.getResults().size();
        InputStreamReader reader = new InputStreamReader(TaskServiceBaseTest.class.getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskHandler = new BlockingAddTaskResponseHandler();
            client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskHandler);
        }
        reader = new InputStreamReader(TaskServiceBaseTest.class.getResourceAsStream("/org/jbpm/task/service/QueryResults_PeopleAssignmentQuerries.mvel"));
        Map expected = (Map)TaskServiceBaseTest.eval(reader, vars);
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsTaskInitiator(users.get("darth").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        List<TaskSummary> actual = getTasksHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(darthSize + 1), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual.subList(0, 1)));
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsBusinessAdministrator(users.get("steve").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        actual = getTasksHandler.getResults();
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual.subList(0, ((List)expected.get("steve")).size())));
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsExcludedOwner(users.get("liz").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        actual = getTasksHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(lizSize + 2), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("liz")), actual.subList(0, ((List)expected.get("liz")).size())));
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        actual = getTasksHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(bobbaSize + 3), (int)actual.size());
        for (TaskSummary orig : (List)expected.get("bobba")) {
            boolean matchFound = false;
            for (TaskSummary ts : actual) {
                if (!orig.equals((Object)ts)) continue;
                matchFound = true;
                break;
            }
            TaskServiceBaseTest.assertTrue((boolean)matchFound);
        }
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsRecipient(users.get("sly").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        actual = getTasksHandler.getResults();
        TaskServiceBaseTest.assertEquals((int)(slySize + 1), (int)actual.size());
        TaskServiceBaseTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("sly")), actual.subList(0, ((List)expected.get("sly")).size())));
    }

    public static class BlockingAllOpenTasksForUseResponseHandler
    implements TaskClientHandler.TaskSummaryResponseHandler {
        private volatile List<TaskSummary> results;
        private volatile RuntimeException error;

        public synchronized void execute(List<TaskSummary> results) {
            this.results = results;
            this.notifyAll();
        }

        public synchronized List<TaskSummary> getResults() {
            if (this.results == null) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.results == null) {
                throw new RuntimeException("Timeout : unable to retrieve results");
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            List<TaskSummary> list = this.results;
            synchronized (list) {
                return this.results != null;
            }
        }

        public void setError(RuntimeException error) {
            this.error = error;
        }

        public RuntimeException getError() {
            return this.error;
        }
    }
}

