/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.task.BaseTestNoUserGroupSetup;
import org.jbpm.task.Group;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.utils.CollectionUtils;

public abstract class TaskServiceBaseUserGroupCallbackTest
extends BaseTestNoUserGroupSetup {
    protected TaskServer server;
    protected TaskClient client;

    public void testTasksOwnedQueryWithI18N() throws Exception {
        TaskServiceBaseUserGroupCallbackTest.runTestTasksOwnedQueryWithI18N(this.client, this.users, this.groups);
    }

    public static void runTestTasksOwnedQueryWithI18N(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceBaseUserGroupCallbackTest.fillVariables(users, groups);
        InputStreamReader reader = new InputStreamReader(TaskServiceBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseUserGroupCallbackTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)responseHandler);
        }
        reader = new InputStreamReader(TaskServiceBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInEnglish.mvel"));
        Map expected = (Map)TaskServiceBaseUserGroupCallbackTest.eval(reader, vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("peter").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("steve").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("darth").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
        reader = new InputStreamReader(TaskServiceBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/service/QueryResults_TasksOwnedInGerman.mvel"));
        expected = (Map)TaskServiceBaseUserGroupCallbackTest.eval(reader, vars);
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("peter").getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("peter")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("steve").getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksOwned(users.get("darth").getId(), "en-DK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
    }

    public void testPotentialOwnerQueries() {
        TaskServiceBaseUserGroupCallbackTest.runTestPotentialOwnerQueries(this.client, this.users, this.groups);
    }

    public static void runTestPotentialOwnerQueries(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceBaseUserGroupCallbackTest.fillVariables(users, groups);
        BlockingAllOpenTasksForUseResponseHandler getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        int bobbaSize = getTasksHandler.getResults().size();
        InputStreamReader reader = new InputStreamReader(TaskServiceBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/service/QueryData_TasksPotentialOwner.mvel"));
        List tasks = (List)TaskServiceBaseUserGroupCallbackTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler responseHandler = new BlockingAddTaskResponseHandler();
            ArrayList<User> businessAdmins = new ArrayList<User>();
            businessAdmins.add(new User("Administrator"));
            businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
            task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
            client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)responseHandler);
        }
        getTasksHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)getTasksHandler);
        List<TaskSummary> actual = getTasksHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)2, (int)actual.size());
    }

    public void testPeopleAssignmentQueries() {
        TaskServiceBaseUserGroupCallbackTest.runTestPeopleAssignmentQueries(this.client, this.users, this.groups, this.taskSession);
    }

    public static void runTestPeopleAssignmentQueries(TaskClient client, Map<String, User> users, Map<String, Group> groups, TaskServiceSession taskSession) {
        Map<String, Object> vars = TaskServiceBaseUserGroupCallbackTest.fillVariables(users, groups);
        InputStreamReader reader = new InputStreamReader(TaskServiceBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/service/QueryData_TasksOwned.mvel"));
        List tasks = (List)TaskServiceBaseUserGroupCallbackTest.eval(reader, vars);
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskHandler = new BlockingAddTaskResponseHandler();
            client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskHandler);
        }
        reader = new InputStreamReader(TaskServiceBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/service/QueryResults_PeopleAssignmentQuerries.mvel"));
        Map expected = (Map)TaskServiceBaseUserGroupCallbackTest.eval(reader, vars);
        BlockingAllOpenTasksForUseResponseHandler responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsTaskInitiator(users.get("darth").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List<TaskSummary> actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("darth")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsBusinessAdministrator(users.get("steve").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("steve")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsExcludedOwner(users.get("liz").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)2, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("liz")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)3, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("bobba")), actual));
        responseHandler = new BlockingAllOpenTasksForUseResponseHandler();
        client.getTasksAssignedAsRecipient(users.get("sly").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        actual = responseHandler.getResults();
        TaskServiceBaseUserGroupCallbackTest.assertEquals((int)1, (int)actual.size());
        TaskServiceBaseUserGroupCallbackTest.assertTrue((boolean)CollectionUtils.equals((List)((List)expected.get("sly")), actual));
    }

    public static class BlockingAllOpenTasksForUseResponseHandler
    implements TaskClientHandler.TaskSummaryResponseHandler {
        private volatile List<TaskSummary> results;
        private volatile RuntimeException error;

        public synchronized void execute(List<TaskSummary> results) {
            this.results = results;
            this.notifyAll();
        }

        public synchronized List<TaskSummary> getResults() {
            if (this.results == null) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.results == null) {
                throw new RuntimeException("Timeout : unable to retrieve results");
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            List<TaskSummary> list = this.results;
            synchronized (list) {
                return this.results != null;
            }
        }

        public void setError(RuntimeException error) {
            this.error = error;
        }

        public RuntimeException getError() {
            return this.error;
        }
    }
}

