/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.BaseTestNoUserGroupSetup;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.MockEscalatedDeadlineHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;

public abstract class TaskServiceEscalationBaseUserGroupCallbackTest
extends BaseTestNoUserGroupSetup {
    protected TaskServer server;
    protected TaskClient client;

    public void testUnescalatedDeadlines() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)handler);
        InputStreamReader reader = new InputStreamReader(TaskServiceEscalationBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseUserGroupCallbackTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
            if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getBusinessAdministrators() != null) {
                ArrayList<User> businessAdmins = new ArrayList<User>();
                businessAdmins.add(new User("Administrator"));
                businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
                task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
            }
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
            addTaskResponseHandler.waitTillDone(3000L);
        }
        TaskServiceEscalationBaseUserGroupCallbackTest.testDeadlines(now, handler);
    }

    public void testUnescalatedDeadlinesOnStartup() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(TaskServiceEscalationBaseUserGroupCallbackTest.class.getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseUserGroupCallbackTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
            if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getBusinessAdministrators() != null) {
                ArrayList<User> businessAdmins = new ArrayList<User>();
                businessAdmins.add(new User("Administrator"));
                businessAdmins.addAll(task.getPeopleAssignments().getBusinessAdministrators());
                task.getPeopleAssignments().setBusinessAdministrators(businessAdmins);
            }
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
            addTaskResponseHandler.waitTillDone(3000L);
        }
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener(), (EscalatedDeadlineHandler)handler);
        TaskServiceEscalationBaseUserGroupCallbackTest.testDeadlines(now, handler);
    }
}

