/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.Group;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public abstract class TaskServiceLifeCycleBaseTest
extends BaseTest {
    private static final int DEFAULT_WAIT_TIME = 5000;
    protected TaskServer server;
    protected TaskClient client;

    public void testNewTaskWithNoPotentialOwners() {
        TaskServiceLifeCycleBaseTest.runTestNewTaskWithNoPotentialOwners(this.client, this.users, this.groups);
    }

    public static void runTestNewTaskWithNoPotentialOwners(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        TaskServiceLifeCycleBaseTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithSinglePotentialOwner() {
        TaskServiceLifeCycleBaseTest.runTestNewTaskWithSinglePotentialOwner(this.client, this.users, this.groups);
    }

    public static void runTestNewTaskWithSinglePotentialOwner(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithContent() {
        TaskServiceLifeCycleBaseTest.runTestNewTaskWithContent(this.client, this.users, this.groups);
    }

    public static void runTestNewTaskWithContent(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, data, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleBaseTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleBaseTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testNewTaskWithLargeContent() {
        TaskServiceLifeCycleBaseTest.runTestNewTaskWithLargeContent(this.client, this.users, this.groups);
    }

    public static void runTestNewTaskWithLargeContent(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        String largeContent = "";
        for (int i = 0; i < 1000; ++i) {
            largeContent = largeContent + i + "xxxxxxxxx";
        }
        data.setContent(largeContent.getBytes());
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, data, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleBaseTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleBaseTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseTest.assertEquals((String)largeContent, (String)new String(content.getContent()));
    }

    public void testClaimWithMultiplePotentialOwners() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestClaimWithMultiplePotentialOwners(this.client, this.users, this.groups);
    }

    public static void runTestClaimWithMultiplePotentialOwners(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testClaimWithGroupAssignee() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestClaimWithGroupAssignee(this.client, this.users, this.groups);
    }

    public static void runTestClaimWithGroupAssignee(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [groups['knightsTempler' ]], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Dummy Group");
        groupIds.add("Knights Templer");
        client.claim(taskId, users.get("darth").getId(), groupIds, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithPotentialOwner() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestStartFromReadyStateWithPotentialOwner(this.client, this.users, this.groups);
    }

    public static void runTestStartFromReadyStateWithPotentialOwner(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithIncorrectPotentialOwner() {
        TaskServiceLifeCycleBaseTest.runTestStartFromReadyStateWithIncorrectPotentialOwner(this.client, this.users, this.groups);
    }

    public static void runTestStartFromReadyStateWithIncorrectPotentialOwner(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReserved() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestStartFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestStartFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStartFromReservedWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestStartFromReservedWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestStartFromReservedWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStop() {
        TaskServiceLifeCycleBaseTest.runTestStop(this.client, this.users, this.groups);
    }

    public static void runTestStop(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.stop(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStopWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestStopWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestStopWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.stop(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromInprogress() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestReleaseFromInprogress(this.client, this.users, this.groups);
    }

    public static void runTestReleaseFromInprogress(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.release(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromReserved() {
        TaskServiceLifeCycleBaseTest.runTestReleaseFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestReleaseFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.release(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestReleaseWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestReleaseWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.release(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReady() {
        TaskServiceLifeCycleBaseTest.runTestSuspendFromReady(this.client, this.users, this.groups);
    }

    public static void runTestSuspendFromReady(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReserved() {
        TaskServiceLifeCycleBaseTest.runTestSuspendFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestSuspendFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testSuspendFromReservedWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runtestSuspendFromReservedWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runtestSuspendFromReservedWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testResumeFromReady() {
        TaskServiceLifeCycleBaseTest.runTestResumeFromReady(this.client, this.users, this.groups);
    }

    public static void runTestResumeFromReady(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.resume(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReserved() {
        TaskServiceLifeCycleBaseTest.runTestResumeFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestResumeFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.resume(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReservedWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestResumeFromReservedWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestResumeFromReservedWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReady() {
        TaskServiceLifeCycleBaseTest.runTestSkipFromReady(this.client, this.users, this.groups);
    }

    public static void runTestSkipFromReady(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.skip(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReserved() {
        TaskServiceLifeCycleBaseTest.runTestSkipFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestSkipFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.skip(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testDelegateFromReady() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestDelegateFromReady(this.client, this.users, this.groups);
    }

    public static void runTestDelegateFromReady(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.delegate(taskId, users.get("darth").getId(), users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("tony")));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReserved() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestDelegateFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestDelegateFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.delegate(taskId, users.get("darth").getId(), users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("tony")));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReservedWithIncorrectUser() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestDelegateFromReservedWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestDelegateFromReservedWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.delegate(taskId, users.get("bobba").getId(), users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("tony")));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReady() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestForwardFromReady(this.client, this.users, this.groups);
    }

    public static void runTestForwardFromReady(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.forward(taskId, users.get("darth").getId(), users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("tony")));
        TaskServiceLifeCycleBaseTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReserved() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestForwardFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestForwardFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.forward(taskId, users.get("darth").getId(), users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask(20000);
        TaskServiceLifeCycleBaseTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("tony")));
        TaskServiceLifeCycleBaseTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReservedWithIncorrectUser() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestForwardFromReservedWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestForwardFromReservedWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.claim(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.forward(taskId, users.get("bobba").getId(), users.get("tony").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(users.get("tony")));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testComplete() {
        TaskServiceLifeCycleBaseTest.runTestComplete(this.client, this.users, this.groups);
    }

    public static void runTestComplete(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskId, users.get("darth").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestCompleteWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestCompleteWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskId, users.get("bobba").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithContent() {
        TaskServiceLifeCycleBaseTest.runTestCompleteWithContent(this.client, this.users, this.groups);
    }

    public static void runTestCompleteWithContent(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.complete(taskId, users.get("darth").getId(), data, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getOutputAccessType());
        TaskServiceLifeCycleBaseTest.assertEquals((String)"type", (String)task2.getTaskData().getOutputType());
        long contentId = task2.getTaskData().getOutputContentId();
        TaskServiceLifeCycleBaseTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testFail() {
        TaskServiceLifeCycleBaseTest.runTestFail(this.client, this.users, this.groups);
    }

    public static void runTestFail(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.fail(taskId, users.get("darth").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestFailWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestFailWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.fail(taskId, users.get("bobba").getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithContent() {
        TaskServiceLifeCycleBaseTest.runTestFailWithContent(this.client, this.users, this.groups);
    }

    public static void runTestFailWithContent(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        FaultData data = new FaultData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setFaultName("faultName");
        data.setContent("content".getBytes());
        responseHandler = new BlockingTaskOperationResponseHandler();
        client.fail(taskId, users.get("darth").getId(), data, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getFaultAccessType());
        TaskServiceLifeCycleBaseTest.assertEquals((String)"type", (String)task2.getTaskData().getFaultType());
        TaskServiceLifeCycleBaseTest.assertEquals((String)"faultName", (String)task2.getTaskData().getFaultName());
        long contentId = task2.getTaskData().getFaultContentId();
        TaskServiceLifeCycleBaseTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testRegisterRemove() throws Exception {
        TaskServiceLifeCycleBaseTest.runTestRegisterRemove(this.client, this.users, this.groups);
    }

    public static void runTestRegisterRemove(TaskClient client, Map<String, User> users, Map<String, Group> groups) throws Exception {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler opResponseHandler = new BlockingTaskOperationResponseHandler();
        client.register(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)opResponseHandler);
        opResponseHandler.waitTillDone(5000L);
        Thread.sleep(500L);
        BlockingGetTaskResponseHandler responseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)responseHandler);
        Task task1 = responseHandler.getTask();
        List myRecipientTasks = task1.getPeopleAssignments().getRecipients();
        TaskServiceLifeCycleBaseTest.assertNotNull((Object)myRecipientTasks);
        TaskServiceLifeCycleBaseTest.assertEquals((int)1, (int)myRecipientTasks.size());
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(users.get("bobba")));
        BlockingTaskOperationResponseHandler removeHandler = new BlockingTaskOperationResponseHandler();
        client.remove(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)removeHandler);
        removeHandler.waitTillDone(5000L);
        Thread.sleep(500L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertFalse((boolean)task2.getPeopleAssignments().getRecipients().contains(users.get("bobba")));
    }

    public void testRemoveNotInRecipientList() {
        TaskServiceLifeCycleBaseTest.runTestRemoveNotInRecipientList(this.client, this.users, this.groups);
    }

    public static void runTestRemoveNotInRecipientList(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ],";
        str = str + "recipients = [users['bobba'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsRecipient(users.get("jabba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List myRecipientTasks = responseHandler.getResults();
        TaskServiceLifeCycleBaseTest.assertNotNull((Object)myRecipientTasks);
        TaskServiceLifeCycleBaseTest.assertEquals((int)0, (int)myRecipientTasks.size());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("jabba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List myPotentialTasks = responseHandler.getResults();
        TaskServiceLifeCycleBaseTest.assertNotNull((Object)myPotentialTasks);
        TaskServiceLifeCycleBaseTest.assertEquals((int)0, (int)myPotentialTasks.size());
        BlockingTaskOperationResponseHandler removeHandler = new BlockingTaskOperationResponseHandler();
        try {
            client.remove(taskId, users.get("jabba").getId(), (TaskClientHandler.TaskOperationResponseHandler)removeHandler);
            removeHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(users.get("bobba")));
    }

    public void testNominateOnOtherThanCreated() {
        TaskServiceLifeCycleBaseTest.runTestNominateOnOtherThanCreated(this.client, this.users, this.groups);
    }

    public static void runTestNominateOnOtherThanCreated(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'] ] ,";
        str = str + " potentialOwners = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler startResponseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)startResponseHandler);
        startResponseHandler.waitTillDone(5000L);
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        try {
            ArrayList<User> potentialOwners = new ArrayList<User>();
            potentialOwners.add(users.get("bobba"));
            client.nominate(taskId, users.get("darth").getId(), potentialOwners, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
            nominateHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)nominateHandler.getError());
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)nominateHandler.getError().getMessage());
            String somethingAboutCreated = "Created";
            String errorMessage = null;
            errorMessage = nominateHandler.getError().getCause() != null ? nominateHandler.getError().getCause().getMessage() : nominateHandler.getError().getMessage();
            TaskServiceLifeCycleBaseTest.assertTrue((String)("Error message does not contain '" + somethingAboutCreated + "' : " + errorMessage), (boolean)errorMessage.contains(somethingAboutCreated));
        }
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(users.get("darth")));
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(users.get("bobba")));
    }

    public void testNominateWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestNominateWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestNominateWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        try {
            ArrayList<User> potentialOwners = new ArrayList<User>(1);
            potentialOwners.add(users.get("jabba"));
            client.nominate(taskId, users.get("darth").getId(), potentialOwners, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
            nominateHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)nominateHandler.getError());
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)nominateHandler.getError().getMessage());
            TaskServiceLifeCycleBaseTest.assertTrue((boolean)nominateHandler.getError().getMessage().contains(users.get("darth").getId()));
        }
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task1.getPeopleAssignments().getBusinessAdministrators().contains(users.get("bobba")));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
    }

    public void testNominateToUser() {
        TaskServiceLifeCycleBaseTest.runTestNominateToUser(this.client, this.users, this.groups);
    }

    public static void runTestNominateToUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        ArrayList<User> potentialOwners = new ArrayList<User>(1);
        potentialOwners.add(users.get("jabba"));
        client.nominate(taskId, users.get("darth").getId(), potentialOwners, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
        nominateHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)task1.getTaskData().getActualOwner(), (Object)users.get("jabba"));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Reserved);
    }

    public void testNominateToGroup() {
        TaskServiceLifeCycleBaseTest.runTestNominateToGroup(this.client, this.users, this.groups);
    }

    public static void runTestNominateToGroup(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        ArrayList<Group> potentialGroups = new ArrayList<Group>();
        potentialGroups.add(groups.get("knightsTempler"));
        client.nominate(taskId, users.get("darth").getId(), potentialGroups, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
        nominateHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(groups.get("knightsTempler")));
        TaskServiceLifeCycleBaseTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
    }

    public void testActivate() {
        TaskServiceLifeCycleBaseTest.runTestActivate(this.client, this.users, this.groups);
    }

    public static void runTestActivate(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { ";
        str = str + "businessAdministrators = [ users['darth'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        client.activate(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        activateResponseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
        TaskServiceLifeCycleBaseTest.assertFalse((boolean)task1.equals((Object)task));
    }

    public void testActivateWithIncorrectUser() {
        TaskServiceLifeCycleBaseTest.runTestActivateWithIncorrectUser(this.client, this.users, this.groups);
    }

    public static void runTestActivateWithIncorrectUser(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ users['darth'], users['bobba'] ], ";
        str = str + "businessAdministrators = [ users['jabba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        try {
            client.activate(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
            activateResponseHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseTest.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)activateResponseHandler.getError());
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)activateResponseHandler.getError().getMessage());
            TaskServiceLifeCycleBaseTest.assertTrue((boolean)activateResponseHandler.getError().getMessage().toLowerCase().contains("status"));
        }
    }

    public void testActivateFromIncorrectStatus() {
        TaskServiceLifeCycleBaseTest.runTestActivateFromIncorrectStatus(this.client, this.users, this.groups);
    }

    public static void runTestActivateFromIncorrectStatus(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ users['darth'], users['bobba'] ], ";
        str = str + "businessAdministrators = [ users['jabba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        try {
            client.activate(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
            activateResponseHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseTest.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)activateResponseHandler.getError());
            TaskServiceLifeCycleBaseTest.assertNotNull((Object)activateResponseHandler.getError().getMessage());
            TaskServiceLifeCycleBaseTest.assertTrue((boolean)activateResponseHandler.getError().getMessage().contains(users.get("darth").getId()));
        }
    }

    public void testExitFromReady() {
        TaskServiceLifeCycleBaseTest.runTestExitFromReady(this.client, this.users, this.groups);
    }

    public static void runTestExitFromReady(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        long taskId = addTaskResponseHandler.getTaskId();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        client.exit(taskId, users.get("admin").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitFromReserved() {
        TaskServiceLifeCycleBaseTest.runTestExitFromReserved(this.client, this.users, this.groups);
    }

    public static void runTestExitFromReserved(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        client.exit(taskId, users.get("admin").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitFromInProgress() {
        TaskServiceLifeCycleBaseTest.runTestExitFromInProgress(this.client, this.users, this.groups);
    }

    public static void runTestExitFromInProgress(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler startResponseHandler = new BlockingTaskOperationResponseHandler();
        client.start(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)startResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.InProgress, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        client.exit(taskId, users.get("admin").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitFromSuspended() {
        TaskServiceLifeCycleBaseTest.runTestExitFromSuspended(this.client, this.users, this.groups);
    }

    public static void runTestExitFromSuspended(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler suspendResponseHandler = new BlockingTaskOperationResponseHandler();
        client.suspend(taskId, users.get("bobba").getId(), (TaskClientHandler.TaskOperationResponseHandler)suspendResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Suspended, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        client.exit(taskId, users.get("admin").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitPermissionDenied() {
        TaskServiceLifeCycleBaseTest.runTestExitPermissionDenied(this.client, this.users, this.groups);
    }

    public static void runTestExitPermissionDenied(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        try {
            BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
            client.exit(taskId, users.get("darth").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
            activateResponseHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseTest.fail((String)"Non admin user can't exit a task");
        }
        catch (PermissionDeniedException e) {
            // empty catch block
        }
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
    }

    public void testExitNotAvailableToUsers() {
        TaskServiceLifeCycleBaseTest.runTestExitNotAvailableToUsers(this.client, this.users, this.groups);
    }

    public static void runTestExitNotAvailableToUsers(TaskClient client, Map<String, User> users, Map<String, Group> groups) {
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        int initialNumTasks = taskSummaryResponseHandler.getResults().size();
        Map<String, Object> vars = TaskServiceLifeCycleBaseTest.fillVariables(users, groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseTest.eval(new StringReader(str), vars);
        client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        client.exit(taskId, users.get("admin").getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        client.getTasksAssignedAsPotentialOwner(users.get("bobba").getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List exitedTasks = taskSummaryResponseHandler.getResults();
        TaskServiceLifeCycleBaseTest.assertEquals((int)initialNumTasks, (int)exitedTasks.size());
    }
}

