/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.async;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.event.TaskCompletedEvent;
import org.jbpm.task.event.TaskEventKey;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingEventResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public abstract class TaskLifeCycleBaseAsyncTest
extends BaseTest {
    protected TaskServer server;
    protected AsyncTaskService client;

    public void testLifeCycle() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(0)).getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(0)).getStatus());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)0, (int)tasks.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseAsyncTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.Completed, (Object)task1.getTaskData().getStatus());
    }

    public void testLifeCycleMultipleTasks() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { workItemId = 1 } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], }),";
        str = str + "descriptions = [ new I18NText( 'en-UK', 'This is my description')], ";
        str = str + "subjects = [ new I18NText( 'en-UK', 'This is my subject')], ";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        long taskId = 0L;
        BlockingEventResponseHandler handler = new BlockingEventResponseHandler();
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        taskId = addTaskResponseHandler.getTaskId();
        TaskLifeCycleBaseAsyncTest.assertTrue((taskId != 0L ? 1 : 0) != 0);
        TaskEventKey key = new TaskEventKey(TaskCompletedEvent.class, taskId);
        this.client.registerForEvent((EventKey)key, true, (EventResponseHandler)handler);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        List tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)((TaskSummary)tasks.get(0)).getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        taskSummaryResponseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler);
        tasks = taskSummaryResponseHandler.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)1, (int)tasks.size());
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)((TaskSummary)tasks.get(0)).getStatus());
        long taskId2 = 0L;
        BlockingEventResponseHandler handler2 = new BlockingEventResponseHandler();
        BlockingAddTaskResponseHandler addTaskResponseHandler2 = new BlockingAddTaskResponseHandler();
        Task task2 = (Task)TaskLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task2, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler2);
        taskId2 = addTaskResponseHandler2.getTaskId();
        TaskLifeCycleBaseAsyncTest.assertTrue((taskId2 != 0L ? 1 : 0) != 0);
        TaskLifeCycleBaseAsyncTest.assertTrue((String)"Tasks should have different ids.", (taskId != taskId2 ? 1 : 0) != 0);
        TaskEventKey key2 = new TaskEventKey(TaskCompletedEvent.class, taskId2);
        this.client.registerForEvent((EventKey)key2, true, (EventResponseHandler)handler2);
        BlockingTaskSummaryResponseHandler taskSummaryResponseHandler2 = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler2);
        List tasks2 = taskSummaryResponseHandler2.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)2, (int)tasks2.size());
        BlockingTaskOperationResponseHandler responseHandler2 = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler2);
        responseHandler2 = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId2, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler2);
        taskSummaryResponseHandler2 = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryResponseHandler2);
        tasks2 = taskSummaryResponseHandler2.getResults();
        TaskLifeCycleBaseAsyncTest.assertEquals((int)1, (int)tasks2.size());
        Payload payload = handler.getPayload();
        TaskCompletedEvent event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseAsyncTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.Completed, (Object)task3.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler3 = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId2, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler3);
        payload = handler2.getPayload();
        event = (TaskCompletedEvent)payload.get();
        TaskLifeCycleBaseAsyncTest.assertNotNull((Object)event);
        BlockingGetTaskResponseHandler getTaskResponseHandler2 = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId2, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler2);
        Task task22 = getTaskResponseHandler2.getTask();
        TaskLifeCycleBaseAsyncTest.assertEquals((Object)Status.Completed, (Object)task22.getTaskData().getStatus());
    }
}

