/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.async;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetContentResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public abstract class TaskServiceLifeCycleBaseAsyncTest
extends BaseTest {
    private static final int DEFAULT_WAIT_TIME = 5000;
    protected TaskServer server;
    protected AsyncTaskService client;

    public void testNewTaskWithNoPotentialOwners() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithSinglePotentialOwner() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, data, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testNewTaskWithLargeContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        String largeContent = "";
        for (int i = 0; i < 1000; ++i) {
            largeContent = largeContent + i + "xxxxxxxxx";
        }
        data.setContent(largeContent.getBytes());
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, data, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)largeContent, (String)new String(content.getContent()));
    }

    public void testClaimWithMultiplePotentialOwners() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testClaimWithGroupAssignee() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [groups['knightsTempler' ]], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Dummy Group");
        groupIds.add("Knights Templer");
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), groupIds, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithPotentialOwner() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithIncorrectPotentialOwner() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReserved() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStartFromReservedWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStop() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.stop(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStopWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.stop(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromInprogress() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.release(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testSuspendFromReservedWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testResumeFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.resume(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.resume(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task3 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReservedWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.skip(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testDelegateFromReady() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.delegate(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReserved() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.delegate(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReservedWithIncorrectUser() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.delegate(taskId, ((User)this.users.get("bobba")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReady() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.forward(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReserved() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.forward(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseAsyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReservedWithIncorrectUser() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.forward(taskId, ((User)this.users.get("bobba")).getId(), ((User)this.users.get("tony")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testComplete() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("darth")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(taskId, ((User)this.users.get("darth")).getId(), data, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getOutputAccessType());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"type", (String)task2.getTaskData().getOutputType());
        long contentId = task2.getTaskData().getOutputContentId();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testFail() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, ((User)this.users.get("darth")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, ((User)this.users.get("bobba")).getId(), null, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        PermissionDeniedException denied = null;
        try {
            responseHandler.waitTillDone(5000L);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        FaultData data = new FaultData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setFaultName("faultName");
        data.setContent("content".getBytes());
        responseHandler = new BlockingTaskOperationResponseHandler();
        this.client.fail(taskId, ((User)this.users.get("darth")).getId(), data, (TaskClientHandler.TaskOperationResponseHandler)responseHandler);
        responseHandler.waitTillDone(5000L);
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getFaultAccessType());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"type", (String)task2.getTaskData().getFaultType());
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"faultName", (String)task2.getTaskData().getFaultName());
        long contentId = task2.getTaskData().getFaultContentId();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        BlockingGetContentResponseHandler getContentResponseHandler = new BlockingGetContentResponseHandler();
        this.client.getContent(contentId, (TaskClientHandler.GetContentResponseHandler)getContentResponseHandler);
        Content content = getContentResponseHandler.getContent();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testRegisterRemove() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler opResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.register(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)opResponseHandler);
        opResponseHandler.waitTillDone(5000L);
        Thread.sleep(500L);
        BlockingGetTaskResponseHandler responseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)responseHandler);
        Task task1 = responseHandler.getTask();
        List myRecipientTasks = task1.getPeopleAssignments().getRecipients();
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)myRecipientTasks);
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((int)1, (int)myRecipientTasks.size());
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(this.users.get("bobba")));
        BlockingTaskOperationResponseHandler removeHandler = new BlockingTaskOperationResponseHandler();
        this.client.remove(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)removeHandler);
        removeHandler.waitTillDone(5000L);
        Thread.sleep(500L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task2 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertFalse((boolean)task2.getPeopleAssignments().getRecipients().contains(this.users.get("bobba")));
    }

    public void testRemoveNotInRecipientList() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ],";
        str = str + "recipients = [users['bobba'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsRecipient(((User)this.users.get("jabba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List myRecipientTasks = responseHandler.getResults();
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)myRecipientTasks);
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((int)0, (int)myRecipientTasks.size());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("jabba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List myPotentialTasks = responseHandler.getResults();
        TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)myPotentialTasks);
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((int)0, (int)myPotentialTasks.size());
        BlockingTaskOperationResponseHandler removeHandler = new BlockingTaskOperationResponseHandler();
        try {
            this.client.remove(taskId, ((User)this.users.get("jabba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)removeHandler);
            removeHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseAsyncTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(this.users.get("bobba")));
    }

    public void testNominateOnOtherThanCreated() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'] ] ,";
        str = str + " potentialOwners = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler startResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)startResponseHandler);
        startResponseHandler.waitTillDone(5000L);
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        try {
            ArrayList potentialOwners = new ArrayList();
            potentialOwners.add(this.users.get("bobba"));
            this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialOwners, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
            nominateHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseAsyncTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)nominateHandler.getError());
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)nominateHandler.getError().getMessage());
            String somethingAboutCreated = "Created";
            String errorMessage = nominateHandler.getError().getMessage();
            TaskServiceLifeCycleBaseAsyncTest.assertTrue((String)("Error message does not contain '" + somethingAboutCreated + "' : " + errorMessage), (boolean)errorMessage.contains(somethingAboutCreated));
        }
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(this.users.get("bobba")));
    }

    public void testNominateWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        try {
            ArrayList potentialOwners = new ArrayList(1);
            potentialOwners.add(this.users.get("jabba"));
            this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialOwners, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
            nominateHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseAsyncTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)nominateHandler.getError());
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)nominateHandler.getError().getMessage());
            TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)nominateHandler.getError().getMessage().contains(((User)this.users.get("darth")).getId()));
        }
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task1.getPeopleAssignments().getBusinessAdministrators().contains(this.users.get("bobba")));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
    }

    public void testNominateToUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        ArrayList potentialOwners = new ArrayList(1);
        potentialOwners.add(this.users.get("jabba"));
        this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialOwners, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
        nominateHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)task1.getTaskData().getActualOwner(), this.users.get("jabba"));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Reserved);
    }

    public void testNominateToGroup() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler nominateHandler = new BlockingTaskOperationResponseHandler();
        ArrayList potentialGroups = new ArrayList();
        potentialGroups.add(this.groups.get("knightsTempler"));
        this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialGroups, (TaskClientHandler.TaskOperationResponseHandler)nominateHandler);
        nominateHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(this.groups.get("knightsTempler")));
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
    }

    public void testActivate() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { ";
        str = str + "businessAdministrators = [ users['darth'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.activate(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        activateResponseHandler.waitTillDone(5000L);
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
        TaskServiceLifeCycleBaseAsyncTest.assertFalse((boolean)task1.equals((Object)task));
    }

    public void testActivateWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ users['darth'], users['bobba'] ], ";
        str = str + "businessAdministrators = [ users['jabba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        try {
            this.client.activate(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
            activateResponseHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseAsyncTest.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)activateResponseHandler.getError());
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)activateResponseHandler.getError().getMessage());
            TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)activateResponseHandler.getError().getMessage().toLowerCase().contains("status"));
        }
    }

    public void testActivateFromIncorrectStatus() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ users['darth'], users['bobba'] ], ";
        str = str + "businessAdministrators = [ users['jabba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        try {
            this.client.activate(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
            activateResponseHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseAsyncTest.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)activateResponseHandler.getError());
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)activateResponseHandler.getError().getMessage());
            TaskServiceLifeCycleBaseAsyncTest.assertTrue((boolean)activateResponseHandler.getError().getMessage().contains(((User)this.users.get("darth")).getId()));
        }
    }

    public void testExitFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        long taskId = addTaskResponseHandler.getTaskId();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.exit(taskId, ((User)this.users.get("admin")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.exit(taskId, ((User)this.users.get("admin")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitFromInProgress() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler startResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)startResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.InProgress, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.exit(taskId, ((User)this.users.get("admin")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitFromSuspended() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler suspendResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.suspend(taskId, ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)suspendResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Suspended, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.exit(taskId, ((User)this.users.get("admin")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
    }

    public void testExitPermissionDenied() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        try {
            BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
            this.client.exit(taskId, ((User)this.users.get("darth")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
            activateResponseHandler.waitTillDone(5000L);
            TaskServiceLifeCycleBaseAsyncTest.fail((String)"Non admin user can't exit a task");
        }
        catch (PermissionDeniedException e) {
            // empty catch block
        }
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
    }

    public void testExitNotAvailableToUsers() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler activateResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.exit(taskId, ((User)this.users.get("admin")).getId(), (TaskClientHandler.TaskOperationResponseHandler)activateResponseHandler);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        task = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Exited, (Object)task.getTaskData().getStatus());
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List exitedTasks = responseHandler.getResults();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((int)0, (int)exitedTasks.size());
    }

    public void testClaimConflictAndRetry() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['salaboy'], users['bobba']], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask((Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars), new ContentData(), (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("salaboy")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List salaboyTasks = responseHandler.getResults();
        Long salaboyTaskId = ((TaskSummary)salaboyTasks.get(0)).getId();
        BlockingGetTaskResponseHandler taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(salaboyTaskId.longValue(), (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        Task salaboyTask = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)salaboyTask.getTaskData().getStatus());
        responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List bobbaTasks = responseHandler.getResults();
        Long bobbaTaskId = ((TaskSummary)bobbaTasks.get(0)).getId();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)bobbaTaskId, (Object)salaboyTaskId);
        taskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(bobbaTaskId.longValue(), (TaskClientHandler.GetTaskResponseHandler)taskResponseHandler);
        Task bobbaTask = taskResponseHandler.getTask();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((Object)Status.Ready, (Object)bobbaTask.getTaskData().getStatus());
        BlockingTaskOperationResponseHandler claimResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claim(bobbaTask.getId().longValue(), ((User)this.users.get("bobba")).getId(), (TaskClientHandler.TaskOperationResponseHandler)claimResponseHandler);
        try {
            claimResponseHandler = new BlockingTaskOperationResponseHandler();
            this.client.claim(salaboyTask.getId().longValue(), ((User)this.users.get("salaboy")).getId(), (TaskClientHandler.TaskOperationResponseHandler)claimResponseHandler);
        }
        catch (PermissionDeniedException ex) {
            TaskServiceLifeCycleBaseAsyncTest.assertNotNull((Object)((Object)ex));
        }
    }

    public void testClaimNextAvailable() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['salaboy'], users['bobba']], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        this.client.addTask((Task)TaskServiceLifeCycleBaseAsyncTest.eval(new StringReader(str), vars), new ContentData(), (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        BlockingTaskOperationResponseHandler claimResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.claimNextAvailable(((User)this.users.get("bobba")).getId(), "en-UK", (TaskClientHandler.TaskOperationResponseHandler)claimResponseHandler);
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwnerByStatus(((User)this.users.get("salaboy")).getId(), status, "en-UK", responseHandler);
        List salaboyTasks = responseHandler.getResults();
        TaskServiceLifeCycleBaseAsyncTest.assertEquals((int)0, (int)salaboyTasks.size());
    }
}

