/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.drools.process.instance.impl.DefaultWorkItemManager;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.MockUserInfo;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.service.DefaultEscalatedDeadlineHandler;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskServer;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public abstract class TaskServiceDeadlinesBaseSyncTest
extends BaseTest {
    protected TaskServer server;
    protected TaskService client;
    private Properties conf;
    private Wiser wiser;

    public void testDelayedEmailNotificationOnDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("darth"), "darth@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("darth"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithNotification.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseSyncTest.eval(reader, vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Content content = new Content();
        content.setContent("['subject' : 'My Subject', 'body' : 'My Body']".getBytes());
        this.client.setDocumentContent(taskId, content);
        long contentId = content.getId();
        content = this.client.getContent(contentId);
        TaskServiceDeadlinesBaseSyncTest.assertEquals((String)"['subject' : 'My Subject', 'body' : 'My Body']", (String)new String(content.getContent()));
        TaskServiceDeadlinesBaseSyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        Thread.sleep(100L);
        TaskServiceDeadlinesBaseSyncTest.assertEquals((int)0, (int)this.getWiser().getMessages().size());
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        TaskServiceDeadlinesBaseSyncTest.assertEquals((int)2, (int)this.getWiser().getMessages().size());
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(((WiserMessage)this.getWiser().getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.getWiser().getMessages().get(1)).getEnvelopeReceiver());
        TaskServiceDeadlinesBaseSyncTest.assertTrue((boolean)list.contains("tony@domain.com"));
        TaskServiceDeadlinesBaseSyncTest.assertTrue((boolean)list.contains("darth@domain.com"));
        MimeMessage msg = ((WiserMessage)this.getWiser().getMessages().get(0)).getMimeMessage();
        TaskServiceDeadlinesBaseSyncTest.assertEquals((Object)"My Body", (Object)msg.getContent());
        TaskServiceDeadlinesBaseSyncTest.assertEquals((String)"My Subject", (String)msg.getSubject());
        TaskServiceDeadlinesBaseSyncTest.assertEquals((String)"from@domain.com", (String)((InternetAddress)msg.getFrom()[0]).getAddress());
        TaskServiceDeadlinesBaseSyncTest.assertEquals((String)"replyTo@domain.com", (String)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        TaskServiceDeadlinesBaseSyncTest.assertEquals((String)"tony@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        TaskServiceDeadlinesBaseSyncTest.assertEquals((String)"darth@domain.com", (String)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress());
    }

    public void FIXME_testDelayedReassignmentOnDeadline() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        DefaultEscalatedDeadlineHandler notificationHandler = new DefaultEscalatedDeadlineHandler(this.getConf());
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        notificationHandler.setManager((WorkItemManager)manager);
        MockUserInfo userInfo = new MockUserInfo();
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("tony"), "tony@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("luke"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("bobba"), "luke@domain.com");
        userInfo.getEmails().put((OrganizationalEntity)this.users.get("jabba"), "luke@domain.com");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("tony"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("luke"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("bobba"), "en-UK");
        userInfo.getLanguages().put((OrganizationalEntity)this.users.get("jabba"), "en-UK");
        notificationHandler.setUserInfo((UserInfo)userInfo);
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)notificationHandler);
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/org/jbpm/task/service/DeadlineWithReassignment.mvel"));
        Task task = (Task)TaskServiceDeadlinesBaseSyncTest.eval(reader, vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Thread.sleep(1000L);
        task = this.client.getTask(taskId);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        ArrayList<String> ids = new ArrayList<String>(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesBaseSyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("tony")).getId()));
        TaskServiceDeadlinesBaseSyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("luke")).getId()));
        for (long time = 0L; this.getWiser().getMessages().size() != 2 && time < 15000L; time += 500L) {
            Thread.sleep(500L);
        }
        task = this.client.getTask(taskId);
        TaskServiceDeadlinesBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        logger.debug(potentialOwners.toString());
        ids = new ArrayList(potentialOwners.size());
        for (OrganizationalEntity entity : potentialOwners) {
            ids.add(entity.getId());
        }
        TaskServiceDeadlinesBaseSyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("bobba")).getId()));
        TaskServiceDeadlinesBaseSyncTest.assertTrue((boolean)ids.contains(((User)this.users.get("jabba")).getId()));
    }

    public void setConf(Properties conf) {
        this.conf = conf;
    }

    public Properties getConf() {
        return this.conf;
    }

    public void setWiser(Wiser wiser) {
        this.wiser = wiser;
    }

    public Wiser getWiser() {
        return this.wiser;
    }
}

