/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.base.sync;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.task.AccessType;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Content;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.User;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.PermissionDeniedException;
import org.jbpm.task.service.TaskServer;

public abstract class TaskServiceLifeCycleBaseSyncTest
extends BaseTest {
    private static final int DEFAULT_WAIT_TIME = 5000;
    protected TaskServer server;
    protected TaskService client;

    public void testNewTaskWithNoPotentialOwners() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithSinglePotentialOwner() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testNewTaskWithContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, data);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleBaseSyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.client.getContent(contentId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testNewTaskWithLargeContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        String largeContent = "";
        for (int i = 0; i < 1000; ++i) {
            largeContent = largeContent + i + "xxxxxxxxx";
        }
        data.setContent(largeContent.getBytes());
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, data);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task1.getTaskData().getDocumentAccessType());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"type", (String)task1.getTaskData().getDocumentType());
        long contentId = task1.getTaskData().getDocumentContentId();
        TaskServiceLifeCycleBaseSyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.client.getContent(contentId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)largeContent, (String)new String(content.getContent()));
    }

    public void testClaimWithMultiplePotentialOwners() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testClaimWithGroupAssignee() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [groups['knightsTempler' ]], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add("Dummy Group");
        groupIds.add("Knights Templer");
        this.client.claim(taskId, ((User)this.users.get("darth")).getId(), groupIds);
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithPotentialOwner() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReadyStateWithIncorrectPotentialOwner() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        PermissionDeniedException denied = null;
        try {
            this.client.start(taskId, ((User)this.users.get("tony")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testStartFromReserved() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        this.client.start(taskId, ((User)this.users.get("bobba")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStartFromReservedWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.start(taskId, ((User)this.users.get("tony")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("bobba"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testStop() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        this.client.getTask(taskId);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.stop(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testStopWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.stop(taskId, ((User)this.users.get("bobba")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromInprogress() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        this.client.getTask(taskId);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.release(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.release(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
    }

    public void testReleaseWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.release(taskId, ((User)this.users.get("bobba")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testSuspendFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.getTask(taskId);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSuspendFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testSuspendFromReservedWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.suspend(taskId, ((User)this.users.get("bobba")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testResumeFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
        this.client.resume(taskId, ((User)this.users.get("darth")).getId());
        Task task3 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.suspend(taskId, ((User)this.users.get("darth")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        this.client.resume(taskId, ((User)this.users.get("darth")).getId());
        Task task3 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task3.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task3.getTaskData().getPreviousStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task3.getTaskData().getActualOwner());
    }

    public void testResumeFromReservedWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.suspend(taskId, ((User)this.users.get("bobba")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testSkipFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.skip(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testSkipFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = true} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        this.client.skip(taskId, ((User)this.users.get("darth")).getId());
        this.client.getTask(taskId);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Obsolete, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
    }

    public void testDelegateFromReady() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.delegate(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReserved() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.delegate(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("tony"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testDelegateFromReservedWithIncorrectUser() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.delegate(taskId, ((User)this.users.get("bobba")).getId(), ((User)this.users.get("tony")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReady() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.forward(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReserved() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.forward(taskId, ((User)this.users.get("darth")).getId(), ((User)this.users.get("tony")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseSyncTest.assertNull((Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task2.getTaskData().getStatus());
    }

    public void testForwardFromReservedWithIncorrectUser() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.claim(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.forward(taskId, ((User)this.users.get("bobba")).getId(), ((User)this.users.get("tony")).getId());
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertFalse((boolean)task2.getPeopleAssignments().getPotentialOwners().contains(this.users.get("tony")));
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task2.getTaskData().getStatus());
    }

    public void testComplete() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.complete(taskId, ((User)this.users.get("darth")).getId(), null);
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Completed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.complete(taskId, ((User)this.users.get("bobba")).getId(), null);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testCompleteWithContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        ContentData data = new ContentData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setContent("content".getBytes());
        this.client.complete(taskId, ((User)this.users.get("darth")).getId(), data);
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getOutputAccessType());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"type", (String)task2.getTaskData().getOutputType());
        long contentId = task2.getTaskData().getOutputContentId();
        TaskServiceLifeCycleBaseSyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.client.getContent(contentId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void testFail() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        this.client.fail(taskId, ((User)this.users.get("darth")).getId(), null);
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        PermissionDeniedException denied = null;
        try {
            this.client.fail(taskId, ((User)this.users.get("bobba")).getId(), null);
        }
        catch (PermissionDeniedException e) {
            denied = e;
        }
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((String)"Should get permissed denied exception", (Object)((Object)denied));
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task2.getTaskData().getActualOwner());
    }

    public void testFailWithContent() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("darth")).getId());
        this.client.getTask(taskId);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task1.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals(this.users.get("darth"), (Object)task1.getTaskData().getActualOwner());
        FaultData data = new FaultData();
        data.setAccessType(AccessType.Inline);
        data.setType("type");
        data.setFaultName("faultName");
        data.setContent("content".getBytes());
        this.client.fail(taskId, ((User)this.users.get("darth")).getId(), data);
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Failed, (Object)task2.getTaskData().getStatus());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)AccessType.Inline, (Object)task2.getTaskData().getFaultAccessType());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"type", (String)task2.getTaskData().getFaultType());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"faultName", (String)task2.getTaskData().getFaultName());
        long contentId = task2.getTaskData().getFaultContentId();
        TaskServiceLifeCycleBaseSyncTest.assertTrue((contentId != -1L ? 1 : 0) != 0);
        Content content = this.client.getContent(contentId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((String)"content", (String)new String(content.getContent()));
    }

    public void FIXME_testRegisterRemove() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'], users['darth'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.register(taskId, ((User)this.users.get("bobba")).getId());
        Task task1 = this.client.getTask(taskId);
        List myRecipientTasks = task1.getPeopleAssignments().getRecipients();
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((Object)myRecipientTasks);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((int)1, (int)myRecipientTasks.size());
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(this.users.get("bobba")));
        this.client.remove(taskId, ((User)this.users.get("bobba")).getId());
        Task task2 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertFalse((boolean)task2.getPeopleAssignments().getRecipients().contains(this.users.get("bobba")));
    }

    public void testRemoveNotInRecipientList() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ] ],";
        str = str + "recipients = [users['bobba'] ] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        List myRecipientTasks = this.client.getTasksAssignedAsRecipient(((User)this.users.get("jabba")).getId(), "en-UK");
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((Object)myRecipientTasks);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((int)0, (int)myRecipientTasks.size());
        List myPotentialTasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("jabba")).getId(), "en-UK");
        TaskServiceLifeCycleBaseSyncTest.assertNotNull((Object)myPotentialTasks);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((int)0, (int)myPotentialTasks.size());
        try {
            this.client.remove(taskId, ((User)this.users.get("jabba")).getId());
            TaskServiceLifeCycleBaseSyncTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task1.getPeopleAssignments().getRecipients().contains(this.users.get("bobba")));
    }

    public void testNominateOnOtherThanCreated() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'] ] ,";
        str = str + " potentialOwners = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.start(taskId, ((User)this.users.get("bobba")).getId());
        try {
            ArrayList potentialOwners = new ArrayList();
            potentialOwners.add(this.users.get("bobba"));
            this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialOwners);
            TaskServiceLifeCycleBaseSyncTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(this.users.get("darth")));
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(this.users.get("bobba")));
    }

    public void testNominateWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        try {
            ArrayList potentialOwners = new ArrayList(1);
            potentialOwners.add(this.users.get("jabba"));
            this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialOwners);
            TaskServiceLifeCycleBaseSyncTest.fail((String)"Shouldn't be successful");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task1.getPeopleAssignments().getBusinessAdministrators().contains(this.users.get("bobba")));
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
    }

    public void testNominateToUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        ArrayList potentialOwners = new ArrayList(1);
        potentialOwners.add(this.users.get("jabba"));
        this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialOwners);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)task1.getTaskData().getActualOwner(), this.users.get("jabba"));
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Reserved);
    }

    public void testNominateToGroup() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { businessAdministrators = [ users['darth'], users['bobba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        ArrayList potentialGroups = new ArrayList();
        potentialGroups.add(this.groups.get("knightsTempler"));
        this.client.nominate(taskId, ((User)this.users.get("darth")).getId(), potentialGroups);
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertTrue((boolean)task1.getPeopleAssignments().getPotentialOwners().contains(this.groups.get("knightsTempler")));
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
    }

    public void testActivate() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { ";
        str = str + "businessAdministrators = [ users['darth'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        this.client.activate(taskId, ((User)this.users.get("darth")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Ready);
    }

    public void testActivateWithIncorrectUser() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ users['darth'], users['bobba'] ], ";
        str = str + "businessAdministrators = [ users['jabba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        try {
            this.client.activate(taskId, ((User)this.users.get("darth")).getId());
            TaskServiceLifeCycleBaseSyncTest.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testActivateFromIncorrectStatus() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { status = Status.Ready } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [ users['darth'], users['bobba'] ], ";
        str = str + "businessAdministrators = [ users['jabba'] ] } ),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        try {
            this.client.activate(taskId, ((User)this.users.get("darth")).getId());
            TaskServiceLifeCycleBaseSyncTest.fail((String)"Shouldn't have succeded");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    public void testExitFromReady() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        this.client.exit(taskId, ((User)this.users.get("admin")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    public void testExitFromReserved() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.client.exit(taskId, ((User)this.users.get("admin")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    public void testExitFromInProgress() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.client.start(taskId, ((User)this.users.get("bobba")).getId());
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.InProgress, (Object)task.getTaskData().getStatus());
        this.client.exit(taskId, ((User)this.users.get("admin")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    public void testExitFromSuspended() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.client.suspend(taskId, ((User)this.users.get("bobba")).getId());
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Suspended, (Object)task.getTaskData().getStatus());
        this.client.exit(taskId, ((User)this.users.get("admin")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
    }

    public void testExitPermissionDenied() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba' ], users['darth'] ], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task.getTaskData().getStatus());
        try {
            this.client.exit(taskId, ((User)this.users.get("darth")).getId());
            TaskServiceLifeCycleBaseSyncTest.fail((String)"Non admin user can't exit a task");
        }
        catch (PermissionDeniedException e) {
            // empty catch block
        }
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)task1.getTaskData().getStatus());
    }

    public void testExitNotAvailableToUsers() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { skipable = false} ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['bobba']], businessAdministrators = [ users['admin']] }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        Task task = (Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null);
        long taskId = task.getId();
        task = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Reserved, (Object)task.getTaskData().getStatus());
        this.client.exit(taskId, ((User)this.users.get("admin")).getId());
        Task task1 = this.client.getTask(taskId);
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Exited, (Object)task1.getTaskData().getStatus());
        List exitedTasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        TaskServiceLifeCycleBaseSyncTest.assertEquals((int)0, (int)exitedTasks.size());
    }

    public void testClaimConflictAndRetry() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['salaboy' ], users['bobba'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        this.client.addTask((Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars), new ContentData());
        List salaboyTasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("salaboy")).getId(), "en-UK");
        Long salaboyTaskId = ((TaskSummary)salaboyTasks.get(0)).getId();
        Task salaboyTask = this.client.getTask(salaboyTaskId.longValue());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)salaboyTask.getTaskData().getStatus());
        List bobbaTasks = this.client.getTasksAssignedAsPotentialOwner(((User)this.users.get("bobba")).getId(), "en-UK");
        Long bobbaTaskId = ((TaskSummary)bobbaTasks.get(0)).getId();
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)bobbaTaskId, (Object)salaboyTaskId);
        Task bobbaTask = this.client.getTask(bobbaTaskId.longValue());
        TaskServiceLifeCycleBaseSyncTest.assertEquals((Object)Status.Ready, (Object)bobbaTask.getTaskData().getStatus());
        this.client.claim(bobbaTask.getId().longValue(), ((User)this.users.get("bobba")).getId());
        try {
            this.client.claim(salaboyTask.getId().longValue(), ((User)this.users.get("salaboy")).getId());
        }
        catch (PermissionDeniedException ex) {
            TaskServiceLifeCycleBaseSyncTest.assertNotNull((Object)((Object)ex));
        }
    }

    public void testClaimNextAvailable() {
        Map<String, Object> vars = this.fillVariables();
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { potentialOwners = [users['salaboy' ], users['bobba'] ], }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        this.client.addTask((Task)TaskServiceLifeCycleBaseSyncTest.eval(new StringReader(str), vars), new ContentData());
        this.client.claimNextAvailable(((User)this.users.get("bobba")).getId(), "en-UK");
        ArrayList<Status> status = new ArrayList<Status>();
        status.add(Status.Ready);
        List salaboyTasks = this.client.getTasksAssignedAsPotentialOwnerByStatus(((User)this.users.get("salaboy")).getId(), status, "en-UK");
        TaskServiceLifeCycleBaseSyncTest.assertEquals((int)0, (int)salaboyTasks.size());
    }
}

