/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.jms;

import java.util.Properties;
import javax.naming.Context;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.drools.SystemEventListenerFactory;
import org.drools.util.ChainedProperties;
import org.drools.util.ClassLoaderUtil;
import org.easymock.EasyMock;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.IcalBaseTest;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.jms.JMSTaskClientConnector;
import org.jbpm.task.service.jms.JMSTaskClientHandler;
import org.jbpm.task.service.jms.JMSTaskServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.subethamail.wiser.Wiser;

public class IcalJMSTest
extends IcalBaseTest {
    private BrokerService broker;
    private Context context;

    @Override
    @BeforeClass
    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.broker.getVmConnectorURI());
        this.context = (Context)EasyMock.createMock(Context.class);
        EasyMock.expect((Object)this.context.lookup("ConnectionFactory")).andReturn((Object)factory).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.context});
        ChainedProperties props = new ChainedProperties("process.email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, ((Object)((Object)this)).getClass(), (boolean)false));
        this.setEmailHost(props.getProperty("host", "locahost"));
        this.setEmailPort(props.getProperty("port", "2345"));
        Properties serverProperties = new Properties();
        serverProperties.setProperty("JMSTaskServer.connectionFactory", "ConnectionFactory");
        serverProperties.setProperty("JMSTaskServer.transacted", "true");
        serverProperties.setProperty("JMSTaskServer.acknowledgeMode", "AUTO_ACKNOWLEDGE");
        serverProperties.setProperty("JMSTaskServer.queueName", "tasksQueue");
        serverProperties.setProperty("JMSTaskServer.responseQueueName", "tasksResponseQueue");
        this.server = new JMSTaskServer(this.taskService, serverProperties, this.context);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        logger.debug("Waiting for the JMS Task Server to come up");
        while (!this.server.isRunning()) {
            Thread.sleep(50L);
        }
        Properties clientProperties = new Properties();
        clientProperties.setProperty("JMSTaskClient.connectionFactory", "ConnectionFactory");
        clientProperties.setProperty("JMSTaskClient.transactedQueue", "true");
        clientProperties.setProperty("JMSTaskClient.acknowledgeMode", "AUTO_ACKNOWLEDGE");
        clientProperties.setProperty("JMSTaskClient.queueName", "tasksQueue");
        clientProperties.setProperty("JMSTaskClient.responseQueueName", "tasksResponseQueue");
        this.client = new TaskClient((TaskClientConnector)new JMSTaskClientConnector("client 1", (BaseClientHandler)new JMSTaskClientHandler(SystemEventListenerFactory.getSystemEventListener()), clientProperties, this.context));
        this.client.connect();
        this.setWiser(new Wiser());
        this.getWiser().setHostname(this.getEmailHost());
        this.getWiser().setPort(Integer.parseInt(this.getEmailPort()));
        this.getWiser().start();
    }

    @Override
    @AfterClass
    protected void tearDown() throws Exception {
        super.tearDown();
        this.client.disconnect();
        this.server.stop();
        this.broker.stop();
        this.getWiser().stop();
    }
}

