/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.jms;

import java.util.ArrayList;
import java.util.Properties;
import javax.naming.Context;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.drools.SystemEventListenerFactory;
import org.easymock.EasyMock;
import org.jbpm.task.Group;
import org.jbpm.task.I18NText;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.jms.JMSTaskClientConnector;
import org.jbpm.task.service.jms.JMSTaskClientHandler;
import org.jbpm.task.service.jms.JMSTaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;

public class JMSTaskServerTest
extends TestCase {
    private Context context;
    private TaskServer server;

    protected void setUp() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.context = (Context)EasyMock.createMock(Context.class);
        EasyMock.expect((Object)this.context.lookup("ConnectionFactory")).andReturn((Object)factory).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.context});
        EntityManagerFactory localEntityManagerFactory = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
        TaskService localTaskService = new TaskService(localEntityManagerFactory, SystemEventListenerFactory.getSystemEventListener());
        TaskServiceSession localTaskServiceSession = localTaskService.createSession();
        for (int i = 0; i < 10; ++i) {
            User user = new User("usr" + i);
            localTaskServiceSession.addUser(user);
        }
        for (int j = 0; j < 3; ++j) {
            localTaskServiceSession.addGroup(new Group("grp" + j));
        }
        Properties serverProperties = new Properties();
        serverProperties.setProperty("JMSTaskServer.connectionFactory", "ConnectionFactory");
        serverProperties.setProperty("JMSTaskServer.transacted", "true");
        serverProperties.setProperty("JMSTaskServer.acknowledgeMode", "AUTO_ACKNOWLEDGE");
        serverProperties.setProperty("JMSTaskServer.queueName", "tasksQueue");
        serverProperties.setProperty("JMSTaskServer.responseQueueName", "tasksResponseQueue");
        this.server = new JMSTaskServer(localTaskService, serverProperties, this.context);
        Thread thread = new Thread((Runnable)this.server);
        thread.start();
        localTaskServiceSession.dispose();
    }

    protected TaskClient createTaskClient() {
        Properties clientProperties = new Properties();
        clientProperties.setProperty("JMSTaskClient.connectionFactory", "ConnectionFactory");
        clientProperties.setProperty("JMSTaskClient.transactedQueue", "true");
        clientProperties.setProperty("JMSTaskClient.acknowledgeMode", "AUTO_ACKNOWLEDGE");
        clientProperties.setProperty("JMSTaskClient.queueName", "tasksQueue");
        clientProperties.setProperty("JMSTaskClient.responseQueueName", "tasksResponseQueue");
        TaskClient client = new TaskClient((TaskClientConnector)new JMSTaskClientConnector("org.jbpm.process.workitem.wsht.WSThroughJMSHumanTaskHandler", (BaseClientHandler)new JMSTaskClientHandler(SystemEventListenerFactory.getSystemEventListener()), clientProperties, this.context));
        return client;
    }

    protected void tearDown() throws Exception {
        this.server.stop();
    }

    public void testDoubleUsage() throws Exception {
        while (!this.server.isRunning()) {
            Thread.sleep(100L);
        }
        TaskClient client = this.createTaskClient();
        client.connect();
        Task task = new Task();
        ArrayList<I18NText> names1 = new ArrayList<I18NText>();
        I18NText text1 = new I18NText("en-UK", "tarea1");
        names1.add(text1);
        task.setNames(names1);
        TaskData taskData = new TaskData();
        taskData.setStatus(Status.Created);
        taskData.setCreatedBy(new User("usr0"));
        taskData.setActualOwner(new User("usr0"));
        task.setTaskData(taskData);
        ContentData data = new ContentData();
        BlockingAddTaskResponseHandler addTaskHandler = new BlockingAddTaskResponseHandler();
        client.addTask(task, data, (TaskClientHandler.AddTaskResponseHandler)addTaskHandler);
        long taskId = addTaskHandler.getTaskId();
        client.disconnect();
        client.connect();
        JMSTaskServerTest.assertTrue((String)"taskId debe ser un valor mayor a cero", (taskId > 0L ? 1 : 0) != 0);
        Task task2 = new Task();
        ArrayList<I18NText> names2 = new ArrayList<I18NText>();
        I18NText text2 = new I18NText("en-UK", "tarea1");
        names2.add(text2);
        task2.setNames(names2);
        TaskData taskData2 = new TaskData();
        taskData2.setStatus(Status.Created);
        taskData2.setCreatedBy(new User("usr0"));
        taskData2.setActualOwner(new User("usr0"));
        task2.setTaskData(taskData2);
        ContentData data2 = new ContentData();
        BlockingAddTaskResponseHandler addTaskHandler2 = new BlockingAddTaskResponseHandler();
        client.addTask(task2, data2, (TaskClientHandler.AddTaskResponseHandler)addTaskHandler2);
        long taskId2 = addTaskHandler2.getTaskId();
        JMSTaskServerTest.assertTrue((String)"taskId2 debe ser un valor mayor a cero", (taskId2 > 0L ? 1 : 0) != 0);
        JMSTaskServerTest.assertNotSame((String)"taskId y taskId2 deben ser distintos", (Object)taskId, (Object)taskId2);
        client.disconnect();
    }
}

