/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.Attachment;
import org.jbpm.task.BaseTest;
import org.jbpm.task.BooleanExpression;
import org.jbpm.task.Comment;
import org.jbpm.task.I18NText;
import org.jbpm.task.Task;
import org.jbpm.task.TaskData;
import org.jbpm.task.User;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.test.impl.TestServerUtil;

public class DataModelTest
extends BaseTest {
    private static final String EMPTY_STRING = "";

    public void testOracleEmptyStringNullTask() throws Exception {
        Properties dsProps = this.loadDataSourceProperties();
        String driverClassName = (String)dsProps.get("driverClassName");
        if (!driverClassName.startsWith("oracle")) {
            return;
        }
        long workItemId = new Date().getTime();
        User user = new User();
        user.setId("mriet");
        this.taskSession.addUser(user);
        Task task = new Task();
        ContentData contentData = new ContentData();
        TaskData taskData = new TaskData();
        taskData.setActualOwner(user);
        task.setTaskData(taskData);
        taskData.setWorkItemId(workItemId);
        Attachment attachment = new Attachment();
        attachment.setName(EMPTY_STRING);
        attachment.setContentType(EMPTY_STRING);
        attachment.setAttachedBy(user);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.add(attachment);
        taskData.setAttachments(attachments);
        Comment comment = new Comment();
        comment.setText(EMPTY_STRING);
        comment.setAddedBy(user);
        ArrayList<Comment> comments = new ArrayList<Comment>();
        comments.add(comment);
        taskData.setComments(comments);
        I18NText text = new I18NText();
        text.setLanguage(EMPTY_STRING);
        text.setText(EMPTY_STRING);
        ArrayList<I18NText> i18nTexts = new ArrayList<I18NText>();
        i18nTexts.add(text);
        task.setDescriptions(i18nTexts);
        task.setNames(i18nTexts);
        task.setSubjects(i18nTexts);
        this.taskSession.addTask(task, contentData);
        this.taskSession.dispose();
        this.emf.close();
        this.emf = this.createEntityManagerFactory();
        this.taskService = new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        this.taskSession = this.taskService.createSession();
        Task task2 = this.taskSession.getTaskByWorkItemId(workItemId);
        DataModelTest.assertTrue((boolean)"mriet".equals(task2.getTaskData().getActualOwner().getId()));
        String nullMessage = "Empty string not converted to null.";
        DataModelTest.assertTrue((String)nullMessage, (null == ((Attachment)task2.getTaskData().getAttachments().get(0)).getContentType() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((Attachment)task2.getTaskData().getAttachments().get(0)).getName() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((Comment)task2.getTaskData().getComments().get(0)).getText() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((I18NText)task2.getNames().get(0)).getText() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((I18NText)task2.getNames().get(0)).getLanguage() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((I18NText)task2.getSubjects().get(0)).getText() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((I18NText)task2.getSubjects().get(0)).getLanguage() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((I18NText)task2.getDescriptions().get(0)).getText() ? 1 : 0) != 0);
        DataModelTest.assertTrue((String)nullMessage, (null == ((I18NText)task2.getDescriptions().get(0)).getLanguage() ? 1 : 0) != 0);
        byte[] serializedData = TestServerUtil.serialize(task2);
        task2 = (Task)TestServerUtil.deserialize(serializedData);
        DataModelTest.assertTrue((boolean)"mriet".equals(task2.getTaskData().getActualOwner().getId()));
        nullMessage = "Null not converted to empty string.";
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((Attachment)task2.getTaskData().getAttachments().get(0)).getContentType()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((Attachment)task2.getTaskData().getAttachments().get(0)).getName()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((Comment)task2.getTaskData().getComments().get(0)).getText()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((I18NText)task2.getNames().get(0)).getText()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((I18NText)task2.getNames().get(0)).getLanguage()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((I18NText)task2.getSubjects().get(0)).getText()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((I18NText)task2.getSubjects().get(0)).getLanguage()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((I18NText)task2.getDescriptions().get(0)).getText()));
        DataModelTest.assertTrue((String)nullMessage, (boolean)EMPTY_STRING.equals(((I18NText)task2.getDescriptions().get(0)).getLanguage()));
    }

    public void testBooleanExpressionSerialization() throws Exception {
        BooleanExpression booleanExpression = new BooleanExpression();
        byte[] serializedData = TestServerUtil.serialize(booleanExpression);
        booleanExpression = (BooleanExpression)TestServerUtil.deserialize(serializedData);
    }
}

