/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.persistence;

import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Task;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.MockEscalatedDeadlineHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.persistence.TaskJTATransactionManager;
import org.jbpm.task.service.persistence.TaskPersistenceManager;
import org.jbpm.task.service.persistence.TaskTransactionManager;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;

public abstract class TaskServiceEscalationBaseTest
extends BaseTest {
    protected TaskServer server;
    protected TaskClient client;

    public void testDummy() {
        TaskServiceEscalationBaseTest.assertTrue((boolean)true);
    }

    public void testUnescalatedDeadlines() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        this.taskService.setEscalatedDeadlineHandler((EscalatedDeadlineHandler)handler);
        InputStreamReader reader = new InputStreamReader(TaskServiceEscalationBaseTest.class.getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        for (Task task : tasks) {
            BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
            this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
            addTaskResponseHandler.waitTillDone(3000L);
        }
        TaskServiceEscalationBaseTest.testDeadlines(now, handler);
    }

    public void testUnescalatedDeadlinesOnStartup() throws Exception {
        Map<String, Object> vars = this.fillVariables();
        InputStreamReader reader = new InputStreamReader(TaskServiceEscalationBaseTest.class.getResourceAsStream("/org/jbpm/task/QueryData_UnescalatedDeadlines.mvel"));
        List tasks = (List)TaskServiceEscalationBaseTest.eval(reader, vars);
        long now = ((Date)vars.get("now")).getTime();
        EntityManager em = this.emf.createEntityManager();
        TaskPersistenceManager tpm = this.useJTA ? new TaskPersistenceManager(em, (TaskTransactionManager)new TaskJTATransactionManager()) : new TaskPersistenceManager(em);
        tpm.beginTransaction();
        for (Task task : tasks) {
            tpm.saveEntity((Object)task);
        }
        tpm.endTransaction(true);
        tpm.endPersistenceContext();
        MockEscalatedDeadlineHandler handler = new MockEscalatedDeadlineHandler();
        new TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener(), (EscalatedDeadlineHandler)handler);
        TaskServiceEscalationBaseTest.testDeadlines(now, handler);
    }
}

