/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.test.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.SystemEventListenerFactory;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.test.impl.TestTaskClientConnector;
import org.jbpm.task.service.test.impl.TestTaskClientHandler;
import org.jbpm.task.service.test.impl.TestTaskServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServerUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestTaskClientConnector.class);
    private static final Random random = new Random();
    public static int sleepMax = 1000;
    public static PauseMode PAUSE_MODE = PauseMode.None;

    public static synchronized void pause() throws Exception {
        int sleep = sleepMax;
        switch (PAUSE_MODE) {
            case Random: {
                sleep = random.nextInt(sleepMax);
            }
            case Constant: {
                logger.trace("Sleeping " + (double)sleep / 1000.0);
                Thread.sleep(sleep);
                break;
            }
        }
    }

    public static byte[] serialize(Object message) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(message);
        oout.close();
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] messageBytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(messageBytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public static TaskServer startServer(TaskService taskService) throws Exception {
        return TestServerUtil.startServer(taskService, 1);
    }

    public static TaskServer startAsyncServer(TaskService taskService) throws Exception {
        return TestServerUtil.startServer(taskService, 1, false);
    }

    public static TaskServer startServer(TaskService taskService, int numClients) throws Exception {
        return TestServerUtil.startServer(taskService, numClients, true);
    }

    public static TaskServer startAsyncServer(TaskService taskService, int numClients) throws Exception {
        return TestServerUtil.startServer(taskService, numClients, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskServer startServer(TaskService taskService, int numClients, boolean synchronous) throws Exception {
        AtomicBoolean running;
        TestTaskServer server = new TestTaskServer(taskService, synchronous);
        server.setNumberOfClients(numClients);
        Thread thread = new Thread(server);
        thread.start();
        AtomicBoolean atomicBoolean = running = server.getRunningNotifier();
        synchronized (atomicBoolean) {
            if (!running.get()) {
                running.wait();
            }
        }
        return server;
    }

    public static TaskClientConnector createTestTaskClientConnector(String clientName, TestTaskServer testServer) {
        TestTaskClientConnector connector = new TestTaskClientConnector(clientName, new TestTaskClientHandler(SystemEventListenerFactory.getSystemEventListener()));
        connector.setQueues(testServer.getQueues());
        connector.setFlags(testServer.getFlags());
        return connector;
    }

    public static enum PauseMode {
        Random,
        Constant,
        None;

    }
}

