/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.hornetq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.jbpm.task.service.SessionWriter;

public class HornetQSessionWriter
implements SessionWriter {
    private final ClientSession session;
    private final ClientProducer producer;

    public HornetQSessionWriter(ClientSession session, ClientProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    @Override
    public void write(Object message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(message);
            ClientMessage clientMessage = this.session.createMessage(true);
            clientMessage.getBodyBuffer().writeBytes(baos.toByteArray());
            this.producer.send((Message)clientMessage);
        }
        catch (IOException e) {
            throw new IOException("Error creating message");
        }
        catch (HornetQException e) {
            throw new IOException("Unable to create message");
        }
    }
}

