/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service.local;

import java.util.List;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.EventTriggerTransport;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TaskService;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.TaskServiceSession;

public class LocalTaskService
implements TaskService {
    private org.jbpm.task.service.TaskService service;
    private TaskServiceSession session;

    public LocalTaskService(org.jbpm.task.service.TaskService taskService) {
        this.service = taskService;
        this.session = this.service.createSession();
    }

    @Override
    public void activate(long taskId, String userId) {
        this.session.taskOperation(Operation.Activate, taskId, userId, null, null, null);
    }

    @Override
    public void addAttachment(long taskId, Attachment attachment, Content content) {
        this.session.addAttachment(taskId, attachment, content);
    }

    @Override
    public void addComment(long taskId, Comment comment) {
        this.session.addComment(taskId, comment);
    }

    @Override
    public void addTask(Task task, ContentData content) {
        this.session.addTask(task, content);
    }

    @Override
    public void claim(long taskId, String userId) {
        this.session.taskOperation(Operation.Claim, taskId, userId, null, null, null);
    }

    @Override
    public void claim(long taskId, String userId, List<String> groupIds) {
        this.session.taskOperation(Operation.Claim, taskId, userId, null, null, groupIds);
    }

    @Override
    public void complete(long taskId, String userId, ContentData outputData) {
        this.session.taskOperation(Operation.Complete, taskId, userId, null, outputData, null);
    }

    @Override
    public boolean connect() {
        return true;
    }

    @Override
    public boolean connect(String address, int port) {
        return true;
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId) {
        this.session.taskOperation(Operation.Delegate, taskId, userId, targetUserId, null, null);
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId, long contentId) {
        this.session.deleteAttachment(taskId, attachmentId, contentId);
    }

    @Override
    public void deleteComment(long taskId, long commentId) {
        this.session.deleteComment(taskId, commentId);
    }

    @Override
    public void deleteFault(long taskId, String userId) {
        this.session.deleteFault(taskId, userId);
    }

    @Override
    public void deleteOutput(long taskId, String userId) {
        this.session.deleteOutput(taskId, userId);
    }

    @Override
    public void disconnect() throws Exception {
    }

    public void dispose() {
        this.session.dispose();
    }

    @Override
    public void exit(long taskId, String userId) {
        this.session.taskOperation(Operation.Exit, taskId, userId, null, null, null);
    }

    @Override
    public void fail(long taskId, String userId, FaultData faultData) {
        this.session.taskOperation(Operation.Fail, taskId, userId, null, faultData, null);
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId) {
        this.session.taskOperation(Operation.Forward, taskId, userId, targetEntityId, null, null);
    }

    @Override
    public Content getContent(long contentId) {
        return this.session.getContent(contentId);
    }

    @Override
    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language) {
        return this.session.getSubTasksAssignedAsPotentialOwner(parentId, userId, language);
    }

    @Override
    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return this.session.getSubTasksByParent(parentId, null);
    }

    @Override
    public Task getTask(long taskId) {
        return this.session.getTask(taskId);
    }

    @Override
    public Task getTaskByWorkItemId(long workItemId) {
        return this.session.getTaskByWorkItemId(workItemId);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return this.session.getTasksAssignedAsBusinessAdministrator(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId, String language) {
        return this.session.getTasksAssignedAsExcludedOwner(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return this.session.getTasksAssignedAsPotentialOwner(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        return this.session.getTasksAssignedAsPotentialOwnerByStatus(userId, status, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language) {
        return this.session.getTasksAssignedAsPotentialOwnerByStatusByGroup(userId, groupIds, status, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language) {
        return this.session.getTasksAssignedAsPotentialOwner(userId, groupIds, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult) {
        return this.session.getTasksAssignedAsPotentialOwner(userId, groupIds, language, firstResult, maxResult);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsRecipient(String userId, String language) {
        return this.session.getTasksAssignedAsRecipient(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId, String language) {
        return this.session.getTasksAssignedAsTaskInitiator(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId, String language) {
        return this.session.getTasksAssignedAsTaskStakeholder(userId, language);
    }

    @Override
    public List<TaskSummary> getTasksOwned(String userId, String language) {
        return this.session.getTasksOwned(userId, language);
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        this.session.nominateTask(taskId, userId, potentialOwners);
    }

    @Override
    @Deprecated
    public List<?> query(String qlString, Integer size, Integer offset) {
        return this.session.query(qlString, size, offset);
    }

    @Override
    public void register(long taskId, String userId) {
        this.session.taskOperation(Operation.Register, taskId, userId, null, null, null);
    }

    @Override
    public void registerForEvent(EventKey key, boolean remove, EventResponseHandler responseHandler) {
        SimpleEventTransport transport = new SimpleEventTransport(this.session, responseHandler, remove);
        this.service.getEventKeys().register(key, transport);
    }

    @Override
    public void release(long taskId, String userId) {
        this.session.taskOperation(Operation.Release, taskId, userId, null, null, null);
    }

    @Override
    public void remove(long taskId, String userId) {
        this.session.taskOperation(Operation.Remove, taskId, userId, null, null, null);
    }

    @Override
    public void resume(long taskId, String userId) {
        this.session.taskOperation(Operation.Resume, taskId, userId, null, null, null);
    }

    @Override
    public void setDocumentContent(long taskId, Content content) {
        this.session.setDocumentContent(taskId, content);
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault) {
        this.session.setFault(taskId, userId, fault);
    }

    @Override
    public void setOutput(long taskId, String userId, ContentData outputContentData) {
        this.session.setOutput(taskId, userId, outputContentData);
    }

    @Override
    public void setPriority(long taskId, String userId, int priority) {
        this.session.setPriority(taskId, userId, priority);
    }

    @Override
    public void skip(long taskId, String userId) {
        this.session.taskOperation(Operation.Skip, taskId, userId, null, null, null);
    }

    @Override
    public void start(long taskId, String userId) {
        this.session.taskOperation(Operation.Start, taskId, userId, null, null, null);
    }

    @Override
    public void stop(long taskId, String userId) {
        this.session.taskOperation(Operation.Stop, taskId, userId, null, null, null);
    }

    @Override
    public void suspend(long taskId, String userId) {
        this.session.taskOperation(Operation.Suspend, taskId, userId, null, null, null);
    }

    @Override
    public void claimNextAvailable(String userId, String language) {
        this.session.claimNextAvailable(userId, language);
    }

    @Override
    public void claimNextAvailable(String userId, List<String> groupIds, String language) {
        this.session.claimNextAvailable(userId, groupIds, language);
    }

    private static class SimpleEventTransport
    implements EventTriggerTransport {
        private boolean remove;
        private EventResponseHandler responseHandler;

        public SimpleEventTransport(TaskServiceSession session, EventResponseHandler responseHandler, boolean remove) {
            this.responseHandler = responseHandler;
            this.remove = remove;
        }

        @Override
        public void trigger(Payload payload) {
            this.responseHandler.execute(payload);
        }

        @Override
        public boolean isRemove() {
            return this.remove;
        }
    }
}

