/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dependencies;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class PackagingTestCase {
    protected static ClassLoader originalClassLoader;
    protected static ClassLoader bundleClassLoader;
    protected static File packageTargetDir;
    protected static final String CLASSPATH_QUALIFIER = "classpath:";
    protected static final String FILE_QUALIFIER = "file:";
    protected static final String hib4PkgLoc = "package/hib4/";
    protected static final String jpa2PkgLoc = "package/jpa2/";
    protected static final String TASKORM_JPA2_XML = "Taskorm-JPA2.xml";
    protected static final String PERSISTENCE_XML = "persistence.xml";
    protected static final String DATASOURCE_PROPERTIES = "datasource.properties";
    protected static final String userGroupCallbackProperties = "jbpm.usergroup.callback.properties";

    @Before
    public void prepareTCCL() {
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
    }

    @After
    public void resetTCCL() throws Exception {
        Thread.currentThread().setContextClassLoader(originalClassLoader);
    }

    protected static <T> void addArrayToList(T[] array, ArrayList<T> list) {
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
    }

    protected static Set<String> getMvelFilePaths() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = "org/jbpm/task";
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        HashSet<String> mvelFilePaths = new HashSet<String>();
        for (File directory : dirs) {
            List<String> mvelFiles = PackagingTestCase.findMvelFiles(directory);
            if (mvelFiles.isEmpty()) continue;
            mvelFilePaths.addAll(mvelFiles);
        }
        return mvelFilePaths;
    }

    private static List<String> findMvelFiles(File directory) {
        File[] files;
        if (!directory.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(PackagingTestCase.findMvelFiles(file));
                continue;
            }
            if (!file.getName().matches(".*(?i:mvel)")) continue;
            String path = file.getPath();
            classes.add(path.substring(path.indexOf("org/jbpm/task")));
        }
        return classes;
    }

    static {
        int index;
        originalClassLoader = Thread.currentThread().getContextClassLoader();
        URL myUrl = originalClassLoader.getResource(PackagingTestCase.class.getName().replace('.', '/') + ".class");
        String classPathBase = "target";
        if (myUrl.getFile().contains(classPathBase)) {
            index = myUrl.getFile().lastIndexOf(classPathBase);
        } else {
            classPathBase = "bin";
            index = myUrl.getFile().lastIndexOf(classPathBase);
        }
        if (index == -1) {
            Assert.fail((String)"Unable to setup packaging test");
        }
        String baseDirPath = myUrl.getFile().substring(0, index);
        File baseDir = new File(baseDirPath);
        File testPackagesDir = new File(baseDir, classPathBase + "/package/");
        try {
            bundleClassLoader = new URLClassLoader(new URL[]{testPackagesDir.toURL()}, originalClassLoader);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)"Unable to build custom class loader");
        }
        packageTargetDir = new File(baseDir, classPathBase + "/test-jars");
        packageTargetDir.mkdirs();
    }
}

