/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dependencies.runner;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class JarTestRunner {
    public static void main(String[] args) {
        try {
            HashSet<Class> testClassSet = null;
            try {
                testClassSet = JarTestRunner.getRunnableTestClasses("org.jbpm.task.service.test");
                testClassSet.addAll(JarTestRunner.getRunnableTestClasses("org.jbpm.task.service.local.sync"));
                testClassSet.addAll(JarTestRunner.getRunnableTestClasses("org.jbpm.task.service.persistence"));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to determine runnable test classes.", e);
            }
            Class[] testClasses = testClassSet.toArray(new Class[testClassSet.size()]);
            Arrays.sort(testClasses, new ClassComparatorByName());
            StringBuilder separator = new StringBuilder();
            for (int i = 0; i < 8; ++i) {
                separator.append("----------");
            }
            assert (testClasses[0] != null);
            System.out.println(">> STARTING TESTS [" + testClasses.length + "]");
            System.out.println(separator);
            JUnitCore jUnit = new JUnitCore();
            boolean testFailed = false;
            StringBuilder failedTestNames = new StringBuilder();
            for (Class testClass : testClasses) {
                System.out.println("Running " + testClass.getSimpleName());
                Result result = jUnit.run(Request.classes((Class[])new Class[]{testClass}));
                if (!result.wasSuccessful()) {
                    List failures = result.getFailures();
                    System.out.println();
                    for (Failure fail : failures) {
                        failedTestNames.append(fail.getTestHeader() + "\n");
                        System.out.println("] " + fail.getTestHeader());
                        fail.getException().printStackTrace();
                        testFailed = true;
                    }
                }
                JarTestRunner.printSummary(result);
                System.out.println(separator);
            }
            System.out.println(">> TESTS DONE");
            if (testFailed) {
                System.out.println("The following tests failed: \n" + failedTestNames);
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Throwable e) {
            System.exit(1);
        }
    }

    private static void printSummary(Result result) {
        System.out.println("Tests run: " + result.getRunCount() + ", Failures: " + result.getFailureCount() + ", Skipped: " + result.getIgnoreCount() + "\n");
    }

    private static HashSet<Class> getRunnableTestClasses(String packageName) throws ClassNotFoundException, IOException {
        URL jarURL = JarTestRunner.getJarURL(packageName);
        String pkgSlash = packageName.replaceAll("\\.", File.separator);
        ZipInputStream zis = new ZipInputStream(jarURL.openStream());
        ZipEntry zippedFile = null;
        HashSet classes = new HashSet();
        while ((zippedFile = zis.getNextEntry()) != null) {
            if (!zippedFile.getName().matches(pkgSlash + "[^$]*class")) continue;
            String className = zippedFile.getName().replaceAll("/", ".").replace(".class", "");
            classes.add(Class.forName(className));
        }
        HashSet testClasses = (HashSet)classes.clone();
        for (Class clazz : classes) {
            JarTestRunner.determineIfThisIsARunnableTestClass(clazz, testClasses);
        }
        return testClasses;
    }

    private static URL getJarURL(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        boolean classFound = false;
        URL jarURL = null;
        while (resources.hasMoreElements()) {
            if (classFound) {
                throw new RuntimeException("More than one location of " + packageName + " in classpath.");
            }
            URL resource = resources.nextElement();
            String jarPath = resource.getPath();
            jarPath = jarPath.substring(jarPath.indexOf("file:"), jarPath.indexOf(33));
            jarURL = new URL(jarPath);
            classFound = true;
        }
        assert (jarURL != null);
        return jarURL;
    }

    private static void determineIfThisIsARunnableTestClass(Class clazz, HashSet<Class> classes) {
        boolean isTest = false;
        if (Modifier.isAbstract(clazz.getModifiers())) {
            isTest = false;
            classes.remove(clazz);
            return;
        }
        Method[] methods = clazz.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if (methods[m].getAnnotation(Test.class) == null) continue;
            isTest = true;
        }
        for (Class superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
            classes.remove(superClazz);
            if (!superClazz.equals(TestCase.class)) continue;
            isTest = true;
        }
        if (!isTest) {
            classes.remove(clazz);
        }
    }

    static class ClassComparatorByName
    implements Comparator<Class> {
        ClassComparatorByName() {
        }

        @Override
        public int compare(Class o1, Class o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getSimpleName().compareTo(o2.getSimpleName());
        }
    }
}

