/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht.hornetq;

import java.io.StringReader;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.jbpm.process.workitem.wsht.WSHumanTaskHandler;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.TestStatefulKnowledgeSession;
import org.jbpm.task.service.BaseClientHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.hornetq.HornetQTaskClientConnector;
import org.jbpm.task.service.hornetq.HornetQTaskClientHandler;
import org.jbpm.task.service.hornetq.HornetQTaskServer;
import org.jbpm.task.service.responsehandlers.BlockingAddTaskResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingGetTaskResponseHandler;
import org.junit.After;
import org.junit.Before;

public class HornetQErrorRecoveryTest
extends BaseTest {
    private TaskServer server;
    private WSHumanTaskHandler handler;
    private TaskClient client;
    private Thread thread;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.server = new HornetQTaskServer(this.taskService, 5153);
        System.out.println("Waiting for the HornetQTask Server to come up");
        try {
            this.startTaskServerThread(this.server, false);
        }
        catch (Exception e) {
            this.startTaskServerThread(this.server, true);
        }
        this.handler = new WSHumanTaskHandler((KnowledgeRuntime)new TestStatefulKnowledgeSession());
        this.client = new TaskClient((TaskClientConnector)new HornetQTaskClientConnector("client 1", (BaseClientHandler)new HornetQTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        boolean connected = this.client.connect("localhost", 5153);
        this.handler.setClient(this.client);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.handler.dispose();
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testRecoveryOfTaskServer() {
        Map<String, Object> vars = HornetQErrorRecoveryTest.fillVariables(this.users, this.groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)HornetQErrorRecoveryTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        HornetQErrorRecoveryTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        HornetQErrorRecoveryTest.assertNull((Object)task1.getTaskData().getActualOwner());
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTaskByWorkItemId(1000L, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        try {
            task1 = getTaskResponseHandler.getTask();
            HornetQErrorRecoveryTest.fail((String)"There is no such task, should fail");
        }
        catch (Exception e) {
            HornetQErrorRecoveryTest.assertTrue((e.getMessage().indexOf("QueryTaskByWorkItemId") != -1 ? 1 : 0) != 0);
        }
        getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        task1 = getTaskResponseHandler.getTask();
        HornetQErrorRecoveryTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        HornetQErrorRecoveryTest.assertNull((Object)task1.getTaskData().getActualOwner());
    }

    public void testRecoveryOfLostConnectionToTaskServer() throws Exception {
        Map<String, Object> vars = HornetQErrorRecoveryTest.fillVariables(this.users, this.groups);
        String str = "(with (new Task()) { priority = 55, taskData = (with( new TaskData()) { } ), ";
        str = str + "peopleAssignments = (with ( new PeopleAssignments() ) { }),";
        str = str + "names = [ new I18NText( 'en-UK', 'This is my task name')] })";
        BlockingAddTaskResponseHandler addTaskResponseHandler = new BlockingAddTaskResponseHandler();
        Task task = (Task)HornetQErrorRecoveryTest.eval(new StringReader(str), vars);
        this.client.addTask(task, null, (TaskClientHandler.AddTaskResponseHandler)addTaskResponseHandler);
        long taskId = addTaskResponseHandler.getTaskId();
        BlockingGetTaskResponseHandler getTaskResponseHandler = new BlockingGetTaskResponseHandler();
        this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
        Task task1 = getTaskResponseHandler.getTask();
        HornetQErrorRecoveryTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
        HornetQErrorRecoveryTest.assertNull((Object)task1.getTaskData().getActualOwner());
        this.server.stop();
        this.server = new HornetQTaskServer(this.taskService, 5153);
        System.out.println("Waiting for the HornetQTask Server to come up");
        try {
            this.startTaskServerThread(this.server, false);
        }
        catch (Exception e) {
            this.startTaskServerThread(this.server, true);
        }
        try {
            getTaskResponseHandler = new BlockingGetTaskResponseHandler();
            this.client.getTask(taskId, (TaskClientHandler.GetTaskResponseHandler)getTaskResponseHandler);
            task1 = getTaskResponseHandler.getTask();
            HornetQErrorRecoveryTest.assertEquals((Object)task1.getTaskData().getStatus(), (Object)Status.Created);
            HornetQErrorRecoveryTest.assertNull((Object)task1.getTaskData().getActualOwner());
        }
        catch (Exception e) {
            HornetQErrorRecoveryTest.fail((String)("Should not happen " + e.getMessage()));
        }
    }
}

