/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.wsht.mina;

import java.util.List;
import java.util.Map;
import org.drools.SystemEventListenerFactory;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.jbpm.process.workitem.wsht.AsyncWSHumanTaskHandler;
import org.jbpm.process.workitem.wsht.CommandBasedWSHumanTaskHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.BaseTest;
import org.jbpm.task.Status;
import org.jbpm.task.TestStatefulKnowledgeSession;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskServer;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.mina.MinaTaskServer;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public class WSHumanTaskMultipleHandlersMinaTest
extends BaseTest {
    protected TestStatefulKnowledgeSession ksession = new TestStatefulKnowledgeSession();
    private TaskClient client = null;
    private TaskServer server;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.server = new MinaTaskServer(this.taskService);
        logger.debug("Waiting for the MinaTask Server to come up");
        try {
            this.startTaskServerThread(this.server, false);
        }
        catch (Exception e) {
            this.startTaskServerThread(this.server, true);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.disconnect();
        this.server.stop();
        super.tearDown();
    }

    public void testAsyncMultipleHandlers() throws Exception {
        this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("client 1", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        SingleCallbackWorkItemManager manager = new SingleCallbackWorkItemManager();
        AsyncWSHumanTaskHandler handler = new AsyncWSHumanTaskHandler((AsyncTaskService)this.client, (KnowledgeRuntime)this.ksession);
        handler.setConnection("127.0.0.1", 9123);
        handler.setManager((WorkItemManager)manager);
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((long)10L, (long)task.getProcessInstanceId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        handler.dispose();
        this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("client 2", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        AsyncWSHumanTaskHandler handler2 = new AsyncWSHumanTaskHandler((AsyncTaskService)this.client, (KnowledgeRuntime)this.ksession);
        handler2.setConnection("127.0.0.1", 9123);
        handler2.setManager((WorkItemManager)manager);
        handler2.connect();
        Thread.sleep(500L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        Thread.sleep(2000L);
        handler2.dispose();
        this.client.disconnect();
        WSHumanTaskMultipleHandlersMinaTest.assertFalse((boolean)manager.isError());
    }

    public void testComandMultipleHandlers() throws Exception {
        this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("client 4", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        this.client.connect("127.0.0.1", 9123);
        SingleCallbackWorkItemManager manager = new SingleCallbackWorkItemManager();
        CommandBasedWSHumanTaskHandler handler = new CommandBasedWSHumanTaskHandler((KnowledgeRuntime)this.ksession);
        handler.setConnection("127.0.0.1", 9123);
        this.ksession.setWorkItemManager(manager);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("Human Task");
        workItem.setParameter("TaskName", (Object)"TaskName");
        workItem.setParameter("Comment", (Object)"Comment");
        workItem.setParameter("Priority", (Object)"10");
        workItem.setParameter("ActorId", (Object)"Darth Vader");
        workItem.setProcessInstanceId(10L);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Thread.sleep(500L);
        BlockingTaskSummaryResponseHandler responseHandler = new BlockingTaskSummaryResponseHandler();
        this.client.getTasksAssignedAsPotentialOwner("Darth Vader", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)responseHandler);
        List tasks = responseHandler.getResults();
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((int)1, (int)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((String)"TaskName", (String)task.getName());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((int)10, (int)task.getPriority());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((String)"Comment", (String)task.getDescription());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((Object)Status.Reserved, (Object)task.getStatus());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((String)"Darth Vader", (String)task.getActualOwner().getId());
        WSHumanTaskMultipleHandlersMinaTest.assertEquals((long)10L, (long)task.getProcessInstanceId());
        BlockingTaskOperationResponseHandler operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.start(task.getId(), "Darth Vader", (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        handler.dispose();
        this.client.disconnect();
        this.client = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("client 5", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
        this.client.connect("127.0.0.1", 9123);
        Thread.sleep(500L);
        CommandBasedWSHumanTaskHandler handler2 = new CommandBasedWSHumanTaskHandler((KnowledgeRuntime)this.ksession);
        handler2.setConnection("127.0.0.1", 9123);
        handler2.connect();
        Thread.sleep(500L);
        operationResponseHandler = new BlockingTaskOperationResponseHandler();
        this.client.complete(task.getId(), "Darth Vader", null, (TaskClientHandler.TaskOperationResponseHandler)operationResponseHandler);
        operationResponseHandler.waitTillDone(5000L);
        Thread.sleep(2000L);
        handler2.dispose();
        this.client.disconnect();
        WSHumanTaskMultipleHandlersMinaTest.assertFalse((String)"work item manager has errors (was completed/aborted more than once)", (boolean)manager.isError());
    }

    private class SingleCallbackWorkItemManager
    implements WorkItemManager {
        private volatile boolean completed;
        private volatile boolean aborted;
        private volatile boolean error;
        private volatile Map<String, Object> results;

        private SingleCallbackWorkItemManager() {
        }

        public synchronized boolean waitTillCompleted(long time) {
            if (!this.isCompleted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isCompleted();
        }

        public synchronized boolean waitTillAborted(long time) {
            if (!this.isAborted()) {
                try {
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isAborted();
        }

        public void abortWorkItem(long id) {
            if (this.aborted || this.completed) {
                this.error = true;
                return;
            }
            this.setAborted(true);
        }

        public synchronized boolean isAborted() {
            return this.aborted;
        }

        private synchronized void setAborted(boolean aborted) {
            this.aborted = aborted;
            this.notifyAll();
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            if (this.aborted || this.completed) {
                this.error = true;
                return;
            }
            this.results = results;
            this.setCompleted(true);
        }

        private synchronized void setCompleted(boolean completed) {
            this.completed = completed;
            this.notifyAll();
        }

        public synchronized boolean isCompleted() {
            return this.completed;
        }

        public Map<String, Object> getResults() {
            return this.results;
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }

        public boolean isError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }
}

