/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task;

import java.util.HashSet;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;

public class EntityManagerFactoryAndTracker
implements EntityManagerFactory {
    private EntityManagerFactory emf;
    private HashSet<EntityManager> entityManagerMap = new HashSet();

    public EntityManagerFactoryAndTracker(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public EntityManager createEntityManager() {
        EntityManager em = this.emf.createEntityManager();
        this.entityManagerMap.add(em);
        return em;
    }

    public EntityManager createEntityManager(Map map) {
        EntityManager em = this.emf.createEntityManager(map);
        this.entityManagerMap.add(em);
        return em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        for (EntityManager em : this.entityManagerMap) {
            try {
                EntityTransaction etx = em.getTransaction();
                if (!etx.isActive()) continue;
                etx.rollback();
            }
            catch (Throwable t) {}
            continue;
            finally {
                try {
                    if (!em.isOpen()) continue;
                    em.clear();
                    em.close();
                }
                catch (Throwable t) {}
            }
        }
        this.emf.close();
    }

    public boolean isOpen() {
        return this.emf.isOpen();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.emf.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.emf.getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.emf.getProperties();
    }

    public Cache getCache() {
        return this.emf.getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.emf.getPersistenceUnitUtil();
    }
}

